package org.lsst.ccs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.CandidateListCompletionHandler;

/**
 * Extend JLine's built-in completion handler to handle giving
 * information on specific parameters. 
 * @author tonyj
 */
class CommandCompletionHandler extends CandidateListCompletionHandler {

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        
        ArrayList<CharSequence> helpCandidates = new ArrayList<>();
        for(CharSequence candidate: candidates) {
            if ( candidate.toString().startsWith("# ") ) {
                helpCandidates.add(candidate);
            }
        }
        
        if ( helpCandidates.size() == candidates.size() && candidates.size() > 0) {
            //FIXME: Using # to indicate parameter help is ugly
            reader.println();
            for ( CharSequence helpCandidate: helpCandidates ) {
                reader.println(helpCandidate.subSequence(1, helpCandidate.length()));                
            }
            reader.drawLine();
            return true;
        } else {
            for ( CharSequence helpCandidate: helpCandidates ) {
                candidates.remove(helpCandidate);
            }
            return super.complete(reader, candidates, pos);
        }
    }

    
}
