package org.lsst.ccs.command.demo;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Argument;

/**
 * A class designed to illustrate how a class can be annotated to accept
 * commands. Note that the only dependencies this class has is on the
 * annotations package.
 *
 * @author The CCS Team
 */
public class DemoCommands implements DemoInterface {

    @Command(description = "Get the temperature of a module", alias = "gt")
    public double getTemperature(@Argument(name = "module", description = "module (0-9)") int module) {
        if (module < 0 || module > 9) {
            throw new IllegalArgumentException("module < 0 or > 9");
        }
        return Math.random();
    }

    @Command(description = "Add two arguments")
    public double add(double a, double b) {
        return a + b;
    }

    @Command(description = "Add any number of arguments")
    public double addAll(String base, double... numbers) {
        double result = 0;
        for (double d : numbers) {
            result += d;
        }
        return result;
    }

    public enum Day {

        SUNDAY, MONDAY, TUESDAY, WEDNESDAY,
        THURSDAY, FRIDAY, SATURDAY
    }

    @Command(description = "Convert day of week to an ordinal", alias = "dow, day")
    public int dayOfWeek(@Argument(name = "Day") Day day) {
        return day.ordinal();
    }

    @Command(description = "Always generates an error")
    public void error() {
        throw new UnsupportedOperationException("This command not allowed");
    }

    @Command(name = "ACrazyLongNameToTestIfHelpFormatingWorks", description = "A very long command that does nothing", level = Command.ENGINEERING1)
    public void longCommand() {
    }
    
    @Command(name = "zcommandWithDefault", description = "A Command with an argument with default value")
    public int zcommandWithDefault(@Argument(name = "arg", defaultValue = "1") int value) {
        return value;
    }
    
    @Command(name = "zcommandWithEmptyDefault", description = "A Command with an argument with empty default value")
    public String zcommandWithEmptyDefault(@Argument(name = "prefix") String prefix, @Argument(name = "arg", defaultValue = "") String post) {
        return prefix+post;
    }
    
    public enum Number {
        ONE, TWO, THREE, FOUR
    }
    
    public enum Holiday {
        XMAS, EASTER
    }
    
    @Command(name = "xcommandWithLotsOfEnumParameters", description = "A Command lots of enum parameters")
    public String xcommandWithLotsOfEnumParameters(@Argument(name = "Day") Day day, @Argument(name = "number") Number number, @Argument(name = "Holiday") Holiday holiday) {
        return day.toString()+number.toString()+holiday.toString();
    }
    
}
