/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import junit.framework.TestCase;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.HelpGenerator;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.demo.RCMReg;
import org.lsst.ccs.command.routes.InnerRoute;
import org.lsst.ccs.command.routes.Route1;
import org.lsst.ccs.command.routes.Route2;

public class HelpGeneratorTest
extends TestCase {
    private HelpGenerator help;
    private CRC32 cksum;

    protected void setUp() throws Exception {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(RCMReg.class);
        Dictionary dict = builder.getCommandDictionary();
        this.cksum = new CRC32();
        PrintWriter printWriter = new PrintWriter(new CheckedOutputStream(new NullOutputStream(), this.cksum), true);
        this.help = new HelpGenerator(printWriter, dict);
    }

    public void testHelp() {
        this.help.help();
        HelpGeneratorTest.assertEquals((long)3745006164L, (long)this.cksum.getValue());
    }

    public void testHelp2() {
        this.help.help("connect");
        HelpGeneratorTest.assertEquals((long)3501005876L, (long)this.cksum.getValue());
    }

    public void testHelp3() {
        try {
            this.help.help("missing");
            HelpGeneratorTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException x) {
            HelpGeneratorTest.assertEquals((long)0L, (long)this.cksum.getValue());
        }
    }

    public void testRouteHelp() {
        CompositeCommandSet allCommands = new CompositeCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        RoutingCommandSet route1 = new RoutingCommandSet("route1", builder.buildCommandSet((Object)new Route1()));
        RoutingCommandSet inner = new RoutingCommandSet("route1/inner", builder.buildCommandSet((Object)new InnerRoute()));
        RoutingCommandSet route2 = new RoutingCommandSet("route2", builder.buildCommandSet((Object)new Route2()));
        allCommands.add((CommandSet)route1);
        allCommands.add((CommandSet)route2);
        allCommands.add((CommandSet)inner);
        Dictionary dict = allCommands.getCommandDictionary();
        PrintWriter printWriter = new PrintWriter(new CheckedOutputStream(new NullOutputStream(), this.cksum), true);
        HelpGenerator help = new HelpGenerator(printWriter, dict);
        help.help();
        HelpGeneratorTest.assertEquals((long)3280034454L, (long)this.cksum.getValue());
        help.help("route1");
        HelpGeneratorTest.assertEquals((long)2466726861L, (long)this.cksum.getValue());
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

