/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.routes.InnerRoute;
import org.lsst.ccs.command.routes.Route1;
import org.lsst.ccs.command.routes.Route2;

public class DictionaryCompleterTest
extends TestCase {
    private Dictionary dict;

    public DictionaryCompleterTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        this.dict = builder.getCommandDictionary();
    }

    public void testComplete() {
        DictionaryCompleter completer = this.dict.getDictionaryCompleter();
        ArrayList list = new ArrayList();
        int pos = completer.complete("", 0, list);
        DictionaryCompleterTest.assertEquals((int)0, (int)pos);
        DictionaryCompleterTest.assertEquals((int)13, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"add ", list.get(1));
        list.clear();
        pos = completer.complete(" ", 1, list);
        DictionaryCompleterTest.assertEquals((int)1, (int)pos);
        DictionaryCompleterTest.assertEquals((int)13, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"add ", list.get(1));
        DictionaryCompleterTest.assertEquals((Object)"error ", list.get(7));
        list.clear();
        pos = completer.complete("\ta", 2, list);
        DictionaryCompleterTest.assertEquals((int)1, (int)pos);
        DictionaryCompleterTest.assertEquals((int)2, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"add ", list.get(0));
        DictionaryCompleterTest.assertEquals((Object)"addAll ", list.get(1));
        list.clear();
        pos = completer.complete("g", 1, list);
        DictionaryCompleterTest.assertEquals((int)0, (int)pos);
        DictionaryCompleterTest.assertEquals((int)1, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"getTemperature ", list.get(0));
        list.clear();
        pos = completer.complete("day", 3, list);
        DictionaryCompleterTest.assertEquals((int)0, (int)pos);
        DictionaryCompleterTest.assertEquals((int)1, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"dayOfWeek ", list.get(0));
        list.clear();
        pos = completer.complete("\tdayOfWeek ", 11, list);
        DictionaryCompleterTest.assertEquals((int)11, (int)pos);
        DictionaryCompleterTest.assertEquals((int)7, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"sunday ", list.get(0));
        list.clear();
        pos = completer.complete("\tdayOfWeek t", 12, list);
        DictionaryCompleterTest.assertEquals((int)11, (int)pos);
        DictionaryCompleterTest.assertEquals((int)2, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"tuesday ", list.get(0));
        list.clear();
        pos = completer.complete("\tday t", 6, list);
        DictionaryCompleterTest.assertEquals((int)5, (int)pos);
        DictionaryCompleterTest.assertEquals((int)2, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"tuesday ", list.get(0));
        list.clear();
        pos = completer.complete("\tdayOfWeek tu", 13, list);
        DictionaryCompleterTest.assertEquals((int)11, (int)pos);
        DictionaryCompleterTest.assertEquals((int)1, (int)list.size());
        DictionaryCompleterTest.assertEquals((Object)"tuesday ", list.get(0));
        list.clear();
        pos = completer.complete("\tdayOfWeek tuw", 14, list);
        DictionaryCompleterTest.assertEquals((int)11, (int)pos);
        DictionaryCompleterTest.assertTrue((boolean)list.isEmpty());
        list.clear();
        pos = completer.complete("xcommandWithLotsOfEnumParameters tu", 35, list);
        DictionaryCompleterTest.assertEquals((int)33, (int)pos);
        DictionaryCompleterTest.assertEquals((int)1, (int)list.size());
        list.clear();
        pos = completer.complete("xcommandWithLotsOfEnumParameters tuesday on", 43, list);
        DictionaryCompleterTest.assertEquals((int)41, (int)pos);
        DictionaryCompleterTest.assertEquals((int)1, (int)list.size());
        list.clear();
        pos = completer.complete("xcommandWithLotsOfEnumParameters tuesday one ", 45, list);
        DictionaryCompleterTest.assertEquals((int)45, (int)pos);
        DictionaryCompleterTest.assertEquals((int)2, (int)list.size());
    }

    public void testCompleteRoutes() {
        CompositeCommandSet allCommands = new CompositeCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        RoutingCommandSet route1 = new RoutingCommandSet("route1", builder.buildCommandSet((Object)new Route1()));
        RoutingCommandSet inner = new RoutingCommandSet("route1/inner", builder.buildCommandSet((Object)new InnerRoute()));
        RoutingCommandSet route2 = new RoutingCommandSet("route2", builder.buildCommandSet((Object)new Route2()));
        allCommands.add((CommandSet)route1);
        allCommands.add((CommandSet)inner);
        allCommands.add((CommandSet)route2);
        Dictionary dict = allCommands.getCommandDictionary();
        DictionaryCompleter completer = dict.getDictionaryCompleter();
        ArrayList list = new ArrayList();
        String shellLine = "route1 ";
        int pos = completer.complete(shellLine, shellLine.length(), list);
        DictionaryCompleterTest.assertEquals((int)list.size(), (int)3);
        DictionaryCompleterTest.assertTrue((boolean)list.contains("doSomethingRoute1 "));
        DictionaryCompleterTest.assertTrue((boolean)list.contains("testRoute1 "));
        DictionaryCompleterTest.assertTrue((boolean)list.contains("set "));
        shellLine = "route1 testRoute1 ";
        list.clear();
        pos = completer.complete(shellLine, shellLine.length(), list);
        DictionaryCompleterTest.assertEquals((int)list.size(), (int)1);
        DictionaryCompleterTest.assertTrue((boolean)((CharSequence)list.get(0)).toString().contains("argRoute1 int"));
        shellLine = "route1 doSomethingRoute1 ";
        list.clear();
        pos = completer.complete(shellLine, shellLine.length(), list);
        DictionaryCompleterTest.assertEquals((int)list.size(), (int)0);
    }
}

