package org.lsst.ccs.command.demo;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

/**
 * A class with overloading annotated commands
 * @author The CCS Team
 */
public class OverloadingCommands {

    public enum What {
        EAT, RUN, SLEEP, PLAY
    }

    public enum When {
        NOW, NEVER, TOMORROW, WHENEVER
    }
    
    
    @Command(description = "do something")
    public String doSomething(What what, @Argument( name="forHowLong" ) int howLong) {
        return "doing: "+what+" for "+howLong;
    }

    @Command(description = "do something more")
    public String doSomething(What what, int howLong, int howOften) {
        return "doing: "+what+" for "+howLong+" this many times "+howOften;
    }
    
    @Command(description = "do something more")
    public String doSomething(What what, int howLong, int howOften, When when) {
        return "doing: "+what+" for "+howLong+" this many times "+howOften+" and do it "+when;
    }
    
}
