/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.annotations.Command;

public abstract class DictionaryUtils {
    static String basicHelpForDictionary(Dictionary dict) {
        return DictionaryUtils.basicHelpForDictionary(dict, "");
    }

    static String basicHelpForDictionary(Dictionary dict, String indent) {
        StringBuilder helpOut = new StringBuilder();
        ArrayList<DictionaryCommand> sorted = new ArrayList<DictionaryCommand>();
        for (DictionaryCommand def : dict) {
            if (def.getCategory() == Command.CommandCategory.SYSTEM) continue;
            sorted.add(def);
        }
        Collections.sort(sorted, new CommandDefinitionComparator());
        DictionaryHelpGenerator helpGenerator = dict.getHelpGenerator();
        for (DictionaryCommand def : sorted) {
            String help = DictionaryUtils.basicHelpForCommand(def);
            if (helpGenerator != null && helpGenerator.hasHelp(def)) {
                help = helpGenerator.modifyHelpForCommand(def, help, true);
            }
            helpOut.append(indent).append(help);
        }
        return helpOut.toString();
    }

    static String basicHelpForCommand(DictionaryCommand def) {
        StringBuilder builder = new StringBuilder();
        builder.append(def.getCommandName());
        for (DictionaryArgument param : def.getArguments()) {
            List<String> allowedValues = param.getAllowedValues();
            builder.append(' ').append(allowedValues.size() == 1 ? allowedValues.get(0) : param.getName());
        }
        if (def.isVarArgs()) {
            builder.append("...");
        }
        if (builder.length() <= 30) {
            for (int i = builder.length(); i < 31; ++i) {
                builder.append(" ");
            }
        } else {
            builder.append("\n                               ");
        }
        builder.append(def.getDescription()).append("\n");
        if (def.getAliases().length > 0) {
            builder.append("    aliases:");
            for (String alias : def.getAliases()) {
                builder.append(" ").append(alias);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    static DictionaryCommand findCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.findCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException ex) {
            return null;
        }
    }

    static boolean containsCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.containsCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException ex) {
            return false;
        }
    }

    static boolean containsDictionaryCommand(Dictionary dict, DictionaryCommand newCmd) {
        for (DictionaryCommand oldCommand : dict) {
            ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
            cmdNameOrAliases.add(oldCommand.getCommandName());
            String[] aliases = oldCommand.getAliases();
            if (aliases != null) {
                cmdNameOrAliases.addAll(Arrays.asList(aliases));
            }
            for (String cmdNameOrAlias : cmdNameOrAliases) {
                if (!newCmd.getCommandName().equals(cmdNameOrAlias)) continue;
                if (newCmd.isVarArgs() && oldCommand.isVarArgs()) {
                    return true;
                }
                if (newCmd.isVarArgs() && newCmd.getArguments().length - 1 <= oldCommand.getArguments().length) {
                    return true;
                }
                if (oldCommand.isVarArgs() && oldCommand.getArguments().length - 1 <= newCmd.getArguments().length) {
                    return true;
                }
                if (newCmd.getArguments().length == oldCommand.getArguments().length) {
                    boolean isOk = false;
                    int i = 0;
                    int nArgs = newCmd.getArguments().length;
                    if (i < nArgs) {
                        DictionaryArgument newArg = newCmd.getArguments()[i];
                        DictionaryArgument oldArg = oldCommand.getArguments()[i];
                        if (newArg.getAllowedValues().isEmpty() || oldArg.getAllowedValues().isEmpty()) {
                            return true;
                        }
                        ArrayList<String> allowedValues = new ArrayList<String>(newArg.getAllowedValues());
                        allowedValues.retainAll(oldArg.getAllowedValues());
                        if (!allowedValues.isEmpty()) {
                            return true;
                        }
                        isOk = true;
                    }
                    if (isOk) continue;
                    return true;
                }
                int oldMaxArgs = oldCommand.getArguments().length;
                int oldMinArgs = DictionaryUtils.getDictionaryCommandMinArguments(oldCommand);
                int newMaxArgs = newCmd.getArguments().length;
                int newMinArgs = DictionaryUtils.getDictionaryCommandMinArguments(newCmd);
                if (newMinArgs <= oldMaxArgs && newMinArgs >= oldMinArgs) {
                    return true;
                }
                if (newMaxArgs > oldMaxArgs || newMaxArgs < oldMinArgs) continue;
                return true;
            }
        }
        return false;
    }

    private static int getDictionaryCommandMinArguments(DictionaryCommand dc) {
        int minArgs = 0;
        for (DictionaryArgument a : dc.getArguments()) {
            if (a.getDefaultValue() != null) continue;
            ++minArgs;
        }
        return minArgs;
    }

    static boolean commandMatch(DictionaryCommand def, BasicCommand tc) throws CommandArgumentMatchException {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
        cmdNameOrAliases.add(def.getCommandName());
        String[] aliases = def.getAliases();
        if (aliases != null) {
            cmdNameOrAliases.addAll(Arrays.asList(aliases));
        }
        for (String cmdNameOrAlias : cmdNameOrAliases) {
            if (!cmdNameOrAlias.equals(command)) continue;
            boolean argumentCountOk = false;
            int cmdNumberOfArguments = def.getArguments().length;
            if (argumentCount == cmdNumberOfArguments) {
                argumentCountOk = true;
            } else if (argumentCount >= cmdNumberOfArguments - 1 && def.isVarArgs()) {
                argumentCountOk = true;
            } else if (argumentCount < cmdNumberOfArguments) {
                argumentCountOk = true;
                for (int i = argumentCount; i < cmdNumberOfArguments; ++i) {
                    if (def.getArguments()[i].getDefaultValue() != null) continue;
                    argumentCountOk = false;
                    break;
                }
            }
            if (!argumentCountOk) continue;
            if (argumentCount == 0) {
                return true;
            }
            Object[] argValues = tc.getArguments();
            if (argValues != null) {
                boolean argMatch = true;
                for (int i = 0; i < argValues.length; ++i) {
                    if (i >= def.getArguments().length) {
                        return true;
                    }
                    List<String> allowedValues = def.getArguments()[i].getAllowedValues();
                    if (allowedValues != null && !allowedValues.isEmpty()) {
                        argMatch = false;
                        for (String allowedValue : allowedValues) {
                            if (!allowedValue.toLowerCase().equals(argValues[i].toString().toLowerCase())) continue;
                            argMatch = true;
                            break;
                        }
                    }
                    if (argMatch) continue;
                    throw new CommandArgumentMatchException("Illegal value \"" + argValues[i] + "\" for argument \"" + def.getArguments()[i].getName() + "\".Allowed values are: " + allowedValues);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private static class CommandDefinitionComparator
    implements Comparator<DictionaryCommand> {
        private CommandDefinitionComparator() {
        }

        @Override
        public int compare(DictionaryCommand o1, DictionaryCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }

    private static class BasicCommandNullArgs
    implements BasicCommand {
        private static final long serialVersionUID = -744230510544974099L;
        private final String commandName;
        private final int argumentCount;

        BasicCommandNullArgs(String commandName, int argumentCount) {
            this.commandName = commandName;
            this.argumentCount = argumentCount;
        }

        @Override
        public int getArgumentCount() {
            return this.argumentCount;
        }

        @Override
        public String getCommand() {
            return this.commandName;
        }

        @Override
        public Object getArgument(int i) {
            return null;
        }

        @Override
        public Object[] getArguments() {
            return null;
        }

        public String toString() {
            return this.prettyToString();
        }
    }
}

