package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.command.annotations.Argument;

/**
 * An implementation of DictionaryArgument based on a single method argument
 * @author turri
 */
class MethodBasedDictionaryArgument implements DictionaryArgument {
    
    private final String name, description, type, simpleType, defaultValue;
    private final List<String> values = new ArrayList<>();
    private AllowedValuesProvider allowedValuesProvider = null;
    private static final long serialVersionUID = -94438408862305319L;
    
    MethodBasedDictionaryArgument(String name, Class type, String description, String defaultValue) {
        this.name = name;
        this.type = type.getCanonicalName();
        this.simpleType = type.getSimpleName();
        if (type.isEnum()) {
            Enum[] enums = ((Class<? extends Enum>) type).getEnumConstants();
            for (Enum e : enums) {
                values.add(e.name().toLowerCase());
            }
        }
        this.defaultValue =  ! defaultValue.equals(Argument.NULL) ? defaultValue : null;
        this.description = description;
    }
    
    @Override
    public String getName() {
        return name;
    }

    /**
     * Get the type of this parameter
     * @return The full canonical type (e.g. java.lang.String)
     */
    @Override
    public String getType() {
        return type;
    }
    
    /**
     * Get the simple type of this parameter
     * @return The simple type (e.g. String)
     */
    @Override
    public String getSimpleType() {
        return simpleType;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public List<String> getAllowedValues() {       
        if (allowedValuesProvider != null) { 
            List<String> allowedValues = allowedValuesProvider.getAllowedValues();
            return allowedValues == null ? Collections.<String>emptyList() : allowedValues;
        } else {
            return values;
        }
    }
    
    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * FIXME: REMOVE REMOVE REMOVE
     * This is a temporary way to set allowed values, pending better fix from Max.
     */
    void setAllowedValuesProvder(AllowedValuesProvider provider) {
        this.allowedValuesProvider = provider;
    }
}
