/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.InputConversionEngine;

public class InputConversionEngineTest
extends TestCase {
    private InputConversionEngine inputConversionEngine;
    private List<Integer> intList;
    private List<Double> doubleList;
    private List<String> stringList;
    private Map<Integer, String> intStringMap;

    public InputConversionEngineTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.inputConversionEngine = new InputConversionEngine();
    }

    public void testConvertArgToType() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", Integer.TYPE);
        InputConversionEngineTest.assertEquals((Object)1234, (Object)result);
    }

    public void testConvertArgToType2() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", Integer.class);
        InputConversionEngineTest.assertEquals((Object)1234, (Object)result);
    }

    public void testConvertArgToType3() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", Float.TYPE);
        InputConversionEngineTest.assertEquals((Object)Float.valueOf(1234.0f), (Object)result);
    }

    public void testConvertArgToType4() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", Double.TYPE);
        InputConversionEngineTest.assertEquals((Object)1234.0, (Object)result);
    }

    public void testConvertArgToType11() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("TrUe", Boolean.TYPE);
        InputConversionEngineTest.assertEquals((Object)true, (Object)result);
    }

    public void testConvertArgToType5() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", String.class);
        InputConversionEngineTest.assertEquals((Object)"1234", (Object)result);
    }

    public void testConvertArgToType6() throws Exception {
        Object result = this.inputConversionEngine.convertArgToType("1234", RandomObject.class);
        InputConversionEngineTest.assertEquals((String)"1234", (String)((RandomObject)result).getArg());
    }

    public void testConvertArgToType7() throws Exception {
        try {
            this.inputConversionEngine.convertArgToType("1234", Random.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (CommandInvocationException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234' to class java.util.Random", (String)x.getMessage());
        }
    }

    public void testConvertArgToType8() throws Exception {
        try {
            this.inputConversionEngine.convertArgToType("4567", RandomObject.class);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (CommandInvocationException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't instantiate class org.lsst.ccs.command.InputConversionEngineTest$RandomObject using string '4567'", (String)x.getMessage());
        }
    }

    public void testConvertArgToType9() throws Exception {
        try {
            this.inputConversionEngine.convertArgToType("1234", Boolean.TYPE);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (CommandInvocationException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234' to Boolean", (String)x.getMessage());
        }
    }

    public void testConvertArgToType10() throws Exception {
        try {
            this.inputConversionEngine.convertArgToType("1234.5", Integer.TYPE);
            InputConversionEngineTest.fail((String)"Should have thrown an exception");
        }
        catch (CommandInvocationException x) {
            InputConversionEngineTest.assertEquals((String)"Error: Can't convert string '1234.5' to class int", (String)x.getMessage());
        }
    }

    public void testArrayConversion() throws Exception {
        int[] intArray = (int[])this.inputConversionEngine.convertArgToType("[ 1, 3, 56 ]", int[].class);
        InputConversionEngineTest.assertTrue((intArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)intArray[0], (int)1);
        InputConversionEngineTest.assertEquals((int)intArray[1], (int)3);
        InputConversionEngineTest.assertEquals((int)intArray[2], (int)56);
        intArray = (int[])this.inputConversionEngine.convertArgToType(" [ 1,3, 56 ] ", int[].class);
        InputConversionEngineTest.assertTrue((intArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)intArray[0], (int)1);
        InputConversionEngineTest.assertEquals((int)intArray[1], (int)3);
        InputConversionEngineTest.assertEquals((int)intArray[2], (int)56);
        double[] doubleArray = (double[])this.inputConversionEngine.convertArgToType("[ 1., 3., 56, 345, 7.223 ]", double[].class);
        InputConversionEngineTest.assertTrue((doubleArray.length == 5 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[0], (Object)1.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[1], (Object)3.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[2], (Object)56.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[3], (Object)345.0);
        InputConversionEngineTest.assertEquals((Object)doubleArray[4], (Object)7.223);
        String[] stringArray = (String[])this.inputConversionEngine.convertArgToType("[ 1., abc,dd#    ] ", String[].class);
        InputConversionEngineTest.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)stringArray[0], (String)"1.");
        InputConversionEngineTest.assertEquals((String)stringArray[1], (String)"abc");
        InputConversionEngineTest.assertEquals((String)stringArray[2], (String)"dd#");
    }

    public void testListConversion() throws Exception {
        this.intList = (List)this.inputConversionEngine.convertArgToType("[1, 3, 56 ]", ((Object)((Object)this)).getClass().getDeclaredField("intList").getGenericType());
        InputConversionEngineTest.assertTrue((this.intList.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((int)this.intList.get(0), (int)1);
        InputConversionEngineTest.assertEquals((int)this.intList.get(1), (int)3);
        InputConversionEngineTest.assertEquals((int)this.intList.get(2), (int)56);
        this.doubleList = (List)this.inputConversionEngine.convertArgToType("[ 1., 3., 56, 345, 7.223 ]", ((Object)((Object)this)).getClass().getDeclaredField("doubleList").getGenericType());
        InputConversionEngineTest.assertTrue((this.doubleList.size() == 5 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(0), (Object)1.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(1), (Object)3.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(2), (Object)56.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(3), (Object)345.0);
        InputConversionEngineTest.assertEquals((Object)this.doubleList.get(4), (Object)7.223);
        this.stringList = (List)this.inputConversionEngine.convertArgToType("[ 1., abc,dd#    ] ", ((Object)((Object)this)).getClass().getDeclaredField("stringList").getGenericType());
        InputConversionEngineTest.assertTrue((this.stringList.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)this.stringList.get(0), (String)"1.");
        InputConversionEngineTest.assertEquals((String)this.stringList.get(1), (String)"abc");
        InputConversionEngineTest.assertEquals((String)this.stringList.get(2), (String)"dd#");
    }

    public void testMapConversion() throws Exception {
        this.intStringMap = (Map)this.inputConversionEngine.convertArgToType("[1:some, 3:555, 56:43askdjf ]", ((Object)((Object)this)).getClass().getDeclaredField("intStringMap").getGenericType());
        InputConversionEngineTest.assertTrue((this.intStringMap.keySet().size() == 3 ? 1 : 0) != 0);
        this.intStringMap.entrySet();
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(1), (String)"some");
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(3), (String)"555");
        InputConversionEngineTest.assertEquals((String)this.intStringMap.remove(56), (String)"43askdjf");
    }

    public void testSplittingGroupsWithBrackets() {
        String consoleInput = "[1, 3, 56 ]";
        List splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertTrue((splits.size() == 3 ? 1 : 0) != 0);
        InputConversionEngineTest.assertEquals((String)((String)splits.get(0)), (String)"1");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(1)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(2)), (String)"56");
        consoleInput = " [  1 ,3,56 ]    ";
        splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertEquals((int)splits.size(), (int)3);
        InputConversionEngineTest.assertEquals((String)((String)splits.get(0)), (String)"1");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(1)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits.get(2)), (String)"56");
        consoleInput = " [ [ 1 ],[3,56] ]    ";
        splits = InputConversionEngine.splitOnBrackets((String)consoleInput);
        InputConversionEngineTest.assertEquals((int)splits.size(), (int)2);
        List splits1 = InputConversionEngine.splitOnBrackets((String)((String)splits.get(0)));
        InputConversionEngineTest.assertEquals((int)splits1.size(), (int)1);
        InputConversionEngineTest.assertEquals((String)((String)splits1.get(0)), (String)"1");
        List splits2 = InputConversionEngine.splitOnBrackets((String)((String)splits.get(1)));
        InputConversionEngineTest.assertEquals((int)splits2.size(), (int)2);
        InputConversionEngineTest.assertEquals((String)((String)splits2.get(0)), (String)"3");
        InputConversionEngineTest.assertEquals((String)((String)splits2.get(1)), (String)"56");
    }

    private static class RandomObject {
        private final String arg;

        public RandomObject(String arg) {
            if (!"1234".equals(arg)) {
                throw new IllegalArgumentException("Illegal value " + arg);
            }
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }
}

