/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.List;
import junit.framework.TestCase;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.routes.InnerRoute;
import org.lsst.ccs.command.routes.Route1;
import org.lsst.ccs.command.routes.Route2;

public class CommandRoutesTest
extends TestCase {
    private final CompositeCommandSet allCommands = new CompositeCommandSet();
    private final CommandSetBuilder builder = new CommandSetBuilder();
    private RoutingCommandSet inner;
    private final RouteSelectionCommandSet routeSelection = new RouteSelectionCommandSet(this.allCommands);

    protected void setUp() throws Exception {
        RoutingCommandSet route1 = new RoutingCommandSet("route1", this.builder.buildCommandSet((Object)new Route1()));
        this.inner = new RoutingCommandSet("route1/inner", this.builder.buildCommandSet((Object)new InnerRoute()));
        RoutingCommandSet route2 = new RoutingCommandSet("route2", this.builder.buildCommandSet((Object)new Route2()));
        this.allCommands.add((CommandSet)route1);
        this.allCommands.add((CommandSet)this.inner);
        this.allCommands.add((CommandSet)route2);
    }

    public void testRoutes() throws CommandInvocationException {
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.allCommands.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.allCommands.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.allCommands.getCommandDictionary(), (String)"route2", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.allCommands.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
    }

    public void testActivateRoute() throws CommandInvocationException {
        this.routeSelection.setActiveRoute("route1");
        CommandRoutesTest.assertEquals((String)"route1", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        this.routeSelection.setActiveRoute("");
        CommandRoutesTest.assertEquals((String)"", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
        try {
            this.routeSelection.setActiveRoute("abc");
            CommandRoutesTest.assertTrue((boolean)false);
        }
        catch (Exception exception) {}
        CommandRoutesTest.assertEquals((String)"", (String)this.routeSelection.getActiveRoute());
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"inner", (int)0));
        CommandRoutesTest.assertFalse((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"doSomethingRoute1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route1/inner", (int)0));
        CommandRoutesTest.assertTrue((boolean)DictionaryUtils.containsCommand((Dictionary)this.routeSelection.getCommandDictionary(), (String)"route2", (int)0));
    }

    public void testRouteSelectionAllowedValues() throws CommandInvocationException, CommandArgumentMatchException {
        TokenizedCommand cmd = new TokenizedCommand("set target route1");
        DictionaryCommand dictCmd = this.routeSelection.getCommandDictionary().findCommand((BasicCommand)cmd);
        List allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route2"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1/inner"));
        CommandRoutesTest.assertEquals((int)allowedValues.size(), (int)3);
        this.routeSelection.invoke((BasicCommand)cmd);
        allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertEquals((int)allowedValues.size(), (int)4);
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("inner"));
        RoutingCommandSet inner_inner = new RoutingCommandSet("route1/inner/inner_inner", this.builder.buildCommandSet((Object)new InnerRoute()));
        this.allCommands.add((CommandSet)inner_inner);
        allowedValues = dictCmd.getArguments()[1].getAllowedValues();
        CommandRoutesTest.assertEquals((int)allowedValues.size(), (int)6);
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("inner/inner_inner"));
        CommandRoutesTest.assertTrue((boolean)allowedValues.contains("route1/inner/inner_inner"));
    }

    public void testRouteIllegalArgument() throws CommandInvocationException, CommandArgumentMatchException {
        TokenizedCommand cmd = new TokenizedCommand("set target fakeRoute");
        try {
            this.routeSelection.invoke((BasicCommand)cmd);
            CommandRoutesTest.assertTrue((boolean)false);
        }
        catch (CommandArgumentMatchException ex) {
            CommandRoutesTest.assertTrue((boolean)ex.getMessage().startsWith("Illegal value \"fakeRoute"));
        }
    }
}

