package org.lsst.ccs.command;

import java.lang.reflect.Method;
import java.util.Collection;

/**
 * interface to define a "Local" Command Dictionary on a per-class basis. It can
 * deliver a <TT>Dictionary</TT> and find a <TT>Method</TT> Object. "Local"
 * means it can be used only where it is built and cannot be exported (these
 * objects are not <TT>Serializable</TT>)
 *
 * @author bamade
 */
public interface LocalCommandDictionary {

	/**
	 * Gets the command dictionary.
	 *
	 * @return The command dictionary.
	 */
	public Dictionary getCommandDictionary();

	/**
	 * Finds the method which should be invoked as a result of a particular
	 * command.
	 *
	 * @param command The command to be invoked
	 * @return The method to be called to invoke the command, or
	 * <code>null</code> if the command is not known.
	 */
	public Method getMethod(BasicCommand command) throws CommandArgumentMatchException;

	/**
	 * *
	 * Finds a <TT>Method</TT> which is linked to a
	 * <TT>DictionaryCommand</TT>.
	 *
	 * @param dc a dictionary command that <B>must</b> be extracted from the
	 * current <TT>Dictionary</TT>
	 * @return The method to be called to invoke the command, or
	 * <code>null</code> if the command is not known.
	 */
	public Method getMethod(DictionaryCommand dc);

    /**
     * @return all the methods that are commands
     */
    public Collection<Method> getMethods() ;

}
