package org.lsst.ccs.command;

import java.io.Serializable;

/**
 * A interface implemented by both TokenizedCommand and RawCommand
 * @author tonyj
 */
public interface BasicCommand extends Serializable {

    /**
     * Get the number of arguments associated with this command
     * @return The argument count
     */
    int getArgumentCount();

    /**
     * Get the root command name (the zeroth token)
     * @return The command name
     */
    String getCommand();
   
    Object getArgument(int i);
    
    Object[] getArguments();
    
}
