package org.lsst.ccs.command;

import java.util.ArrayList;

/**
 * An implementation of Dictionary which implements commands by linking to
 * annotated methods on an underlying command.
 *
 * @author tonyj
 */


class MethodBasedCommandDictionary extends ArrayList<DictionaryCommand> implements Dictionary {

    private static final long serialVersionUID = 4401762766383746012L;
    private final DefaultDictionaryCompleter completer = new DefaultDictionaryCompleter(this);
  
    @Override
    public boolean containsCommand(BasicCommand tc) {
        return findCommand(tc) != null;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<DictionaryCommand> matches = new ArrayList<>();

        for (DictionaryCommand def : this) {     
            if ( DictionaryUtils.commandMatch(def, tc) ) {
                matches.add(def);
            }
        }
        if ( matches.isEmpty() ) {
            return null;
        } else if ( matches.size() == 1 ) {
            return matches.get(0);
        } else {
            throw new AmbiguousCommandException("Error finding command "+command+" with "+argumentCount+" arguments: "+matches.size()+" matches found in MethodBasedCommandDictionary");
        }
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return completer;
    }
    
}
