package org.lsst.ccs.command;

import java.util.HashMap;
import java.util.Map;

/**
 * static utilities to handle <TT>LocalCommandDictionary</TT>
 * @author bamade
 */
public class LocalBuilders {

	private static Map<Class, LocalCommandDictionary> mapBuilders = new HashMap<>();

	/**
	 * *
	 * this factory gets a <TT>LocalCommandDictionary</TT> which might be in
	 * a local cache.
	 *
	 * @ImplNote (by bamade) This is useful for subsystems that use many
	 * instances of the same class and may be more useful if we implement
	 *  <TT>LocalCommandDictionary</TT> classes systematically as
	 * <TT>CompositeCommandDictionaryBuilder</TT> that delegates to
	 * super-class (by limiting the way we climb up the class hierarchy to
	 * classes in "org.lsst.ccs" packages)
	 * @return
	 */
	public static synchronized LocalCommandDictionary factory(Class clazz) {
		return buildFor(clazz);
	}

	private static LocalCommandDictionary buildFor(Class clazz) {
		LocalCommandDictionary res = mapBuilders.get(clazz);
		if (res == null) {
			res = new CommandDictionaryBuilder(clazz);
			mapBuilders.put(clazz, res);
		}
		return res;

	}
        
}
