package org.lsst.ccs.command;

/**
 * An interface to be implemented by classes providing Help Support for DictionaryCommands.
 * @author turri
 */
public interface DictionaryHelpGenerator {
    
    /**
     * Check if help support is provided for the given command.
     * 
     * @param command The Dictionary Command.
     * @return true if help support is provided for the given command.
     */
    boolean hasHelp(DictionaryCommand command);

        
    /**
     * Modify the current help for the command.
     * 
     * @param command The Dictionary Command.
     * @param help    The current help string for the command
     * @param compact True if the version of the help is in compact form.
     * @return        The modified help
     * 
     */
    String modifyHelpForCommand(DictionaryCommand command, String help, boolean compact);

    
}
