package org.lsst.ccs.command;

import java.util.List;

/**
 * Performs command completion, based on the information available in the
 * command dictionary. This is designed to be jline compatible, but not actually
 * implement jline's command completer to avoid adding a permanent dependency on
 * jline.
 *
 * @author tonyj
 */
public interface DictionaryCompleter {

    /**
     * Generate a list of possible command completions.
     *
     * @param buffer The current content of the input line
     * @param index The index within the input line of the cursor
     * @param list A list which this routine should fill with possible command
     * completions.
     * @return The position at which the cursor should be positioned prior to
     * adding any of the returned items to the buffer.
     */
    public int complete(String buffer, int index, List<CharSequence> list);

}
