package org.lsst.ccs.command;

import java.io.Serializable;

/**
 * A command dictionary contains all the information needed to provide
 * help and perform tab completion. It does not by itself provide sufficient
 * functionality to invoke a command, for this a CommandSet which is a combination of a 
 * command dictionary and a command invoker is required. A CommandDictionary is a collection of
 * CommandDefinitions, plus a few convenience methods.
 * @author tonyj
 */
public interface Dictionary extends Iterable<DictionaryCommand>, Serializable {

    /**
     * Test if a given command is present in a dictionary.
     * @param command The command (or alias) to search for
     * @return <code>true</code>If the command is found
     */
    public boolean containsCommand(BasicCommand command);
    
    /**
     * Find a given command in the dictionary
     * @param command The command (or alias) to search for
     * @return The DictionaryCommand, or <code>null</code> if 
     * the command is not found.
     */
    public DictionaryCommand findCommand(BasicCommand command);

    /**
     * The size of the dictionary.
     * @return The number of commands in this dictionary.
     */
    public int size();  
        
    /**
     * Get the DictionaryHelpGenerator for this Dictionary.
     * 
     * @return The DictionaryHelpGenerator. null if none is available.
     */
    default DictionaryHelpGenerator getHelpGenerator() {
        return null;
    }
    
    /**
     * Get the DictionaryCompleter for this Dictionary.
     * 
     * @return The DictionaryCompleter for this Dictionary.
     */
    default DictionaryCompleter getDictionaryCompleter() {
        return null;
    }
}
