package org.lsst.ccs.command;

import java.util.ArrayList;

/**
 *
 * @author tonyj
 */
class MethodBasedCommandDictionary extends ArrayList<DictionaryCommand> implements Dictionary {

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return findCommand(tc) != null;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        return findCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public boolean containsCommand(String command, int argumentCount) {
        return findCommand(command, argumentCount) != null;
    }

    @Override
    public DictionaryCommand findCommand(String command, int argumentCount) {
        for (DictionaryCommand def : this) {
            if (def.getCommandName().equals(command) && (argumentCount == def.getArguments().length || (argumentCount >= def.getArguments().length-1 && def.isVarArgs()))) {
                return def;
            }
            for (String alias : def.getAliases()) {
                if (alias.equals(command) && (argumentCount == def.getArguments().length || (argumentCount >= def.getArguments().length-1 && def.isVarArgs()))) {
                    return def;
                }
            }
        }
        return null;
    }
    
}
