/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.StringTokenizer;

public class TokenizedCommand
implements BasicCommand {
    private final List<StringTokenizer.Token> tokens;

    public TokenizedCommand(String command) {
        this.tokens = StringTokenizer.tokenize(command);
    }

    @Override
    public String getCommand() {
        return this.tokens.get(0).getString();
    }

    int getCommandLocation() {
        return this.tokens.get(0).getLocation();
    }

    public String getArgument(int index) {
        return this.tokens.get(index + 1).getString();
    }

    int getArgumentLocation(int index) {
        return this.tokens.get(index + 1).getLocation();
    }

    @Override
    public int getArgumentCount() {
        return Math.max(this.tokens.size() - 1, 0);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }
}

