package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

/**
 * A command dictionary to which other command dictionaries can be added and
 * removed.
 *
 * @author tonyj
 */
/*
* note by Bernard AMADE: why was this class turned public though it was package friendly?
* if you implement a method f() that returns a Dictionary
* this method is built using a CommandSetBuilder
* now if you have another method g() with the same feature
* if you want to create a composite which uses the result of f() and g()
* you have to reuse 2 CommandSetBuilder from the ground up .
* or  have methods m() and n() that return an intermediary CommandSet
* and build first a CompositeCommandSet!
* so not worth the hassle!
 */
public class CompositeCommandDictionary implements Dictionary {

    private LinkedHashSet<Dictionary> dicts = new LinkedHashSet<>();

    public void add(Dictionary commandDictionary) {
        dicts.add(commandDictionary);
    }

    public void remove(Dictionary commandDictionary) {
        dicts.remove(commandDictionary);
    }

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return containsCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        return findCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public boolean containsCommand(String command, int argumentCount) {
        for (Dictionary dict : dicts) {
            if (dict.containsCommand(command, argumentCount)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public DictionaryCommand findCommand(String command, int argumentCount) {
        for (Dictionary dict : dicts) {
            if (dict.containsCommand(command, argumentCount)) {
                return dict.findCommand(command, argumentCount);
            }
        }
        return null;
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        // Brute force implementation, could do better
        ArrayList<DictionaryCommand> allCommands = new ArrayList<>();
        for (Dictionary dict : dicts) {
            for (DictionaryCommand def : dict) {
                allCommands.add(def);
            }
        }
        return allCommands.iterator();
    }

    @Override
    public int size() {
        int result = 0;
        for (Dictionary dict : dicts) {
            result += dict.size();
        }
        return result;
    }
}
