/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryContext;
import org.lsst.ccs.utilities.beanutils.Optional;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionariesTree
implements Iterable<DictionaryContext> {
    private final TreeBranch<DictionaryContext> topNode;
    private LinkedHashMap<String, TreeBranch<DictionaryContext>> map;

    public DictionariesTree(TreeBranch<DictionaryContext> topNode) {
        this.topNode = topNode;
        Iterator iterator = topNode.nodeIterator();
        while (iterator.hasNext()) {
            TreeBranch node = (TreeBranch)iterator.next();
            DictionaryContext dictionaryContext = (DictionaryContext)node.getContent();
            this.map.put(dictionaryContext.getName(), (TreeBranch<DictionaryContext>)node);
        }
    }

    public Optional<Dictionary> getDictionaryFor(String componentName) {
        TreeBranch<DictionaryContext> node = this.map.get(componentName);
        if (node != null) {
            return Optional.of((Object)((DictionaryContext)node.getContent()).getDictionary());
        }
        return Optional.empty();
    }

    public TreeBranch<DictionaryContext> getTopNode() {
        return this.topNode;
    }

    public TreeNode getNodeFor(String componentName) {
        return (TreeNode)this.map.get(componentName);
    }

    @Override
    public Iterator<DictionaryContext> iterator() {
        return this.topNode.iterator();
    }

    public Iterator<String> namesIterator() {
        return new Iterator<String>(){
            Iterator<DictionaryContext> ctxIterator;
            {
                this.ctxIterator = DictionariesTree.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.ctxIterator.hasNext();
            }

            @Override
            public String next() {
                DictionaryContext dictCtx = this.ctxIterator.next();
                return dictCtx.getName();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove in nameIterator");
            }
        };
    }
}

