package org.lsst.ccs.command;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.lsst.ccs.command.annotations.Command;

/**
 * 
 * @author tonyj
 */
class RoutingDictionary implements Dictionary {
    
    private LinkedHashMap<String,DictionaryCommand> routeMap = new LinkedHashMap<>();
    
    void add(String route, Dictionary dict) {
        routeMap.put(route,new RoutingCommand(route,dict));
    }
    
    void remove(String route) {
        routeMap.remove(route);
    }

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return containsCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        return findCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public boolean containsCommand(String command, int argumentCount) {
        return routeMap.containsKey(command);
    }

    @Override
    public DictionaryCommand findCommand(String command, int argumentCount) {
        return routeMap.get(command);
    }

    @Override
    public int size() {
        return routeMap.size();
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        return routeMap.values().iterator();
    }
    
    private static class RoutingCommand implements DictionaryCommand {
        private final String route;
        private final Dictionary dict;
        private final static DictionaryArgument[] THE_COMMAND = { new RoutingArgument() };

        private RoutingCommand(String route, Dictionary dict) {
            this.route = route;
            this.dict = dict;
        }

        @Override
        public String[] getAliases() {
            return NO_ALIASES;
        }

        @Override
        public DictionaryArgument[] getArguments() {
            return THE_COMMAND;
        }

        @Override
        public String getCommandName() {
            return route;
        }

        @Override
        public String getDescription() {
            return "Route command to a different dictionary";
        }

        @Override
        public Command.CommandType getType() {
            return Command.CommandType.QUERY;
        }

        @Override
        public boolean isVarArgs() {
            return true;
        }

        @Override
        public int getLevel() {
            return Command.NORMAL;
        }

        @Override
        public boolean matchesCommandOrAlias(String value) {
            return route.equals(value);
        }
    } 
    private static class RoutingArgument implements DictionaryArgument {

        @Override
        public String getDescription() {
            return "The command to execute";
        }

        @Override
        public String getName() {
            return "command...";
        }

        @Override
        public String getSimpleType() {
            return "String";
        }

        @Override
        public String getType() {
            return "java.lang.String";
        }

        @Override
        public List<String> getValues() {
            return Collections.<String>emptyList(); 
        }
        
    }
}
