package org.lsst.ccs.command;

/**
 *
 * @author tonyj
 */
public class RoutingCommandSet implements CommandSet {

    RoutingDictionary dict = new RoutingDictionary();
    
    public void add(String route, CommandSet cs) {
        Dictionary subDict = cs.getCommandDictionary();
        dict.add(route, subDict);
    }
    
    public void remove(String route) {
        dict.remove(route);
    }
    
    @Override
    public Dictionary getCommandDictionary() {
        return dict;
    }

    @Override
    public Object invoke(BasicCommand command) throws CommandInvocationException {
        DictionaryCommand dc = dict.findCommand(command);
        if (dc == null) {
           throw new CommandInvocationException("Error: No handler found for command %s with %d arguments",command.getCommand(),command.getArgumentCount());
        }
        return null;
    }
    
}
