package org.lsst.ccs.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * An implementation of DictionaryArgument based on a single method argument
 * @author turri
 */
class MethodBasedDictionaryArgument implements DictionaryArgument {
    
    private String name;
    private String description;
    private String type;
    private String simpleType;
    private String[] values;
    
    MethodBasedDictionaryArgument(String name, Class type, String description) {
        this.name = name;
        this.type = type.getCanonicalName();
        this.simpleType = type.getSimpleName();
        if (type.isEnum()) {
            Enum[] enums = ((Class<? extends Enum>) type).getEnumConstants();
            values = new String[enums.length];
            for (int i=0; i<enums.length; i++) {
                values[i] = enums[i].name().toLowerCase();
            }
        }
        this.description = description;
    }
    
    @Override
    public String getName() {
        return name;
    }

    /**
     * Get the type of this parameter
     * @return The full canonical type (e.g. java.lang.String)
     */
    @Override
    public String getType() {
        return type;
    }
    
    /**
     * Get the simple type of this parameter
     * @return The simple type (e.g. String)
     */
    @Override
    public String getSimpleType() {
        return simpleType;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public List<String> getValues() {
        return values == null ? Collections.<String>emptyList() : Collections.unmodifiableList(Arrays.asList(values));
    }
    
    String getDefaultValue() {
        //FIXME: Not implemented yet
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
}
