package org.lsst.ccs.command;

import java.util.List;

/**
 * A command with pre-parsed arguments (Objects).
 *
 * @author tonyj
 */
public class RawCommand implements BasicCommand {

    private final String command;
    private final List<Object> arguments;

    /**
     * Builds a Raw Command.
     *
     * @param command The command string to be tokenized.
     */
    public RawCommand(String command, List<Object> arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    /**
     * Get the root command name (the zeroth token)
     *
     * @return The command name
     */
    @Override
    public String getCommand() {
        return command;
    }

    /**
     * Get a specific command argument
     *
     * @param index The index of the argument
     * @return The command argument at the given index
     */
    Object getArgument(int index) {
        return arguments.get(index);
    }

    /**
     * Get the number of arguments associated with this command
     *
     * @return The argument count
     */
    @Override
    public int getArgumentCount() {
        return arguments.size();
    }

    Object[] getArguments() {
        return arguments.toArray();
    }
}
