package org.lsst.ccs.command;

import java.io.Serializable;
import org.lsst.ccs.command.annotations.Command;

/**
 * Encapsulate the dictionary information for a single command and parameters.
 * This class is serializable for use in client-server applications, so does not
 * maintain any references to Class or Method objects which may not be available
 * in a remote client.
 * @author tonyj
 */
public interface DictionaryCommand extends Serializable {

    final static String[] NO_ALIASES = new String[0];

    String[] getAliases();

    DictionaryArgument[] getArguments();

    String getCommandName();

    String getDescription();

    Command.CommandType getType();

    boolean isVarArgs();

    /**
     * Test if value matches this command (either the command itself or one if
     * its aliases).
     *
     * @param value The value to test
     * @return <code>true</code> if the value matches
     */
    boolean matchesCommandOrAlias(String value);
    
}
