package org.lsst.ccs.command;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.utilities.tracers.Tracer;

import java.lang.reflect.Method;

/**
 * Builds a command dictionary for a given class using annotations on the
 * methods of the class.
 *
 * @author tonyj
 */
class DictionaryBuilder {

    static {
        assert Tracer.version("$Rev$", DictionaryBuilder.class, "org-lsst-ccs-command-core");
    }

    /**
     * Build a command dictionary for a class using annotations on the methods
     * of the class. Note, this is a convenience class, only used for test cases.
     *
     * @param targetClass The class for which the dictionary should be built
     * @return The dictionary created.
     */
    Dictionary build(Class targetClass) {
        MethodBasedCommandDictionary dict = new MethodBasedCommandDictionary();
        for (Method method : targetClass.getMethods()) {
            Command annotation = method.getAnnotation(Command.class);
            if (annotation != null) {
                dict.add(new MethodBasedDictionaryCommand(method, annotation));
            }
        }
        // FIXME: Should this throw an exception if no annotations are found, or just and 
        // empty dictionary as we do now?
        return dict;
    }
}
