/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryParameter;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class HelpGenerator {
    private final Dictionary dict;
    private final PrintWriter out;

    public HelpGenerator(PrintWriter out, Dictionary dict) {
        this.out = out;
        this.dict = dict;
    }

    @Command(description="List available commands")
    public void help() {
        ArrayList<DictionaryCommand> sorted = new ArrayList<DictionaryCommand>();
        for (DictionaryCommand def : this.dict) {
            sorted.add(def);
        }
        Collections.sort(sorted, new CommandDefinitionComparator());
        for (DictionaryCommand def : sorted) {
            this.helpForCommand(def);
        }
    }

    @Command(description="Show help for a single command")
    public void help(@Argument(name="command") String command) {
        boolean foundCommand = false;
        for (DictionaryCommand def : this.dict) {
            if (!def.getCommandName().equals(command)) continue;
            foundCommand = true;
            this.helpForCommand(def);
            int maxNameLeng = 0;
            int maxTypeLeng = 0;
            DictionaryParameter[] dictionaryParameterArray = def.getParams();
            int n = dictionaryParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                DictionaryParameter param = dictionaryParameterArray[n2];
                int leng = param.getName().length();
                maxNameLeng = leng > maxNameLeng ? leng : maxNameLeng;
                leng = param.getSimpleType().length();
                maxTypeLeng = leng > maxTypeLeng ? leng : maxTypeLeng;
                ++n2;
            }
            String spaces = String.format("%80s", "");
            DictionaryParameter[] dictionaryParameterArray2 = def.getParams();
            int n3 = dictionaryParameterArray2.length;
            n = 0;
            while (n < n3) {
                DictionaryParameter param = dictionaryParameterArray2[n];
                String name = param.getName();
                String type = param.getSimpleType();
                this.out.printf("    %s%s   %s%s   %s\n", name, spaces.substring(0, maxNameLeng - name.length()), type, spaces.substring(0, maxTypeLeng - type.length()), param.getDescription());
                ++n;
            }
        }
        if (!foundCommand) {
            throw new IllegalArgumentException("No help found for " + command);
        }
    }

    private void helpForCommand(DictionaryCommand def) {
        StringBuilder builder = new StringBuilder();
        builder.append(def.getCommandName());
        Object[] objectArray = def.getParams();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DictionaryParameter param = objectArray[n2];
            builder.append(' ').append(param.getName());
            ++n2;
        }
        if (def.isVarArgs()) {
            builder.append("...");
        }
        this.out.printf(builder.length() <= 30 ? "%-30s %s\n" : "%s\n                               %s\n", builder, def.getDescription());
        if (def.getAliases().length > 0) {
            this.out.printf("    aliases:", new Object[0]);
            objectArray = def.getAliases();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object alias = objectArray[n2];
                this.out.printf(" %s", alias);
                ++n2;
            }
            this.out.println();
        }
    }

    private static class CommandDefinitionComparator
    implements Comparator<DictionaryCommand> {
        private CommandDefinitionComparator() {
        }

        @Override
        public int compare(DictionaryCommand o1, DictionaryCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }
}

