/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryParameter;
import org.lsst.ccs.command.TokenizedCommand;

public class DictionaryCompleter {
    private final Dictionary dict;

    public DictionaryCompleter(Dictionary dict) {
        this.dict = dict;
    }

    public int complete(String buffer, int index, List<CharSequence> list) {
        TreeSet<String> set;
        boolean endsWithWhiteSpace;
        TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
        int argCount = tc.getArgumentCount();
        boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
        if (endsWithWhiteSpace) {
            ++argCount;
        }
        if (tc.isEmpty()) {
            set = new TreeSet<String>();
            for (DictionaryCommand def : this.dict) {
                String command = def.getCommandName();
                command = String.valueOf(command) + " ";
                set.add(command);
                String[] stringArray = def.getAliases();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String alias = stringArray[n2];
                    alias = String.valueOf(alias) + " ";
                    set.add(alias);
                    ++n2;
                }
            }
        } else {
            if (argCount == 0) {
                String prefix = tc.getCommand();
                TreeSet<String> set2 = new TreeSet<String>();
                HashSet<DictionaryCommand> uniqueCommands = new HashSet<DictionaryCommand>();
                for (DictionaryCommand def : this.dict) {
                    String command = def.getCommandName();
                    if (command.startsWith(prefix)) {
                        command = String.valueOf(command) + " ";
                        set2.add(command);
                        uniqueCommands.add(def);
                    }
                    String[] stringArray = def.getAliases();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String alias = stringArray[n3];
                        if (alias.startsWith(prefix)) {
                            alias = String.valueOf(alias) + " ";
                            set2.add(alias);
                            uniqueCommands.add(def);
                        }
                        ++n3;
                    }
                }
                if (set2.size() > 1 && uniqueCommands.size() == 1) {
                    list.add(String.valueOf(((DictionaryCommand)uniqueCommands.iterator().next()).getCommandName()) + " ");
                } else {
                    list.addAll(set2);
                }
                return tc.getCommandLocation();
            }
            String command = tc.getCommand();
            String lastArg = endsWithWhiteSpace ? "" : tc.getArgument(argCount - 1);
            for (DictionaryCommand def : this.dict) {
                if (!def.matchesCommandOrAlias(command) || def.getParams().length < argCount && !def.isVarArgs()) continue;
                DictionaryParameter currentArg = def.getParams()[Math.min(argCount, def.getParams().length) - 1];
                List<String> values = currentArg.getValues();
                if (values.isEmpty()) {
                    list.add("# " + currentArg.getName() + " " + currentArg.getSimpleType() + " " + currentArg.getDescription());
                    continue;
                }
                for (String value : values) {
                    if (!DictionaryCompleter.startsWithIgnoreCase(value, lastArg)) continue;
                    value = String.valueOf(value) + " ";
                    list.add(value);
                }
            }
            return endsWithWhiteSpace ? index : tc.getArgumentLocation(argCount - 1);
        }
        list.addAll(set);
        return index;
    }

    private static boolean startsWithIgnoreCase(String reference, String test) {
        if (test.length() > reference.length()) {
            return false;
        }
        return reference.substring(0, test.length()).equalsIgnoreCase(test);
    }
}

