/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.lsst.ccs.command.DictionaryParameter;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class DictionaryCommand
implements Serializable {
    private final String description;
    private final String[] aliases;
    private final DictionaryParameter[] params;
    private final Command.CommandType type;
    private final String name;
    private final boolean hasVarArgs;
    private static final String[] NO_ALIASES = new String[0];

    DictionaryCommand(Method method, Command annotation) {
        this.description = annotation.description();
        this.aliases = this.splitAliases(annotation.alias());
        this.type = annotation.type();
        this.name = annotation.name().isEmpty() ? method.getName() : annotation.name();
        this.hasVarArgs = method.isVarArgs();
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] parAnnotations = method.getParameterAnnotations();
        this.params = new DictionaryParameter[types.length];
        int i = 0;
        while (i < types.length) {
            String parName = "arg" + i;
            String parDescription = "";
            Annotation[] annotationArray = parAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a instanceof Argument) {
                    Argument paramAnnotation = (Argument)a;
                    parName = paramAnnotation.name().isEmpty() ? parName : paramAnnotation.name();
                    parDescription = paramAnnotation.description();
                    break;
                }
                ++n2;
            }
            Class<?> parameterType = this.hasVarArgs && i == types.length - 1 ? types[i].getComponentType() : types[i];
            this.params[i] = new DictionaryParameter(parName, parameterType, parDescription);
            ++i;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public DictionaryParameter[] getParams() {
        return this.params;
    }

    public Command.CommandType getType() {
        return this.type;
    }

    public String getCommandName() {
        return this.name;
    }

    public boolean isVarArgs() {
        return this.hasVarArgs;
    }

    public boolean matchesCommandOrAlias(String value) {
        if (this.name.equals(value)) {
            return true;
        }
        String[] stringArray = this.aliases;
        int n = this.aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (alias.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] splitAliases(String alias) {
        return alias.length() > 0 ? alias.split("\\s?,\\s?") : NO_ALIASES;
    }
}

