/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.utilities.tracers.Tracer;

class DictionaryBuilder {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !DictionaryBuilder.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", DictionaryBuilder.class, (String)"org-lsst-ccs-command-core")) {
            throw new AssertionError();
        }
    }

    DictionaryBuilder() {
    }

    Dictionary build(Class targetClass) {
        CommandDictionaryImplementation dict = new CommandDictionaryImplementation();
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Command annotation = method.getAnnotation(Command.class);
            if (annotation != null) {
                dict.add(new DictionaryCommand(method, annotation));
            }
            ++n2;
        }
        return dict;
    }

    private static class CommandDictionaryImplementation
    extends ArrayList<DictionaryCommand>
    implements Dictionary {
        private CommandDictionaryImplementation() {
        }

        @Override
        public boolean containsCommand(BasicCommand tc) {
            return this.findCommand(tc) != -1;
        }

        @Override
        public int findCommand(BasicCommand tc) {
            return this.findCommand(tc.getCommand(), tc.getArgumentCount());
        }

        @Override
        public boolean containsCommand(String command, int argumentCount) {
            return this.findCommand(command, argumentCount) != -1;
        }

        @Override
        public int findCommand(String command, int argumentCount) {
            int index = 0;
            for (DictionaryCommand def : this) {
                if (def.getCommandName().equals(command) && (argumentCount == def.getParams().length || argumentCount > def.getParams().length && def.isVarArgs())) {
                    return index;
                }
                String[] stringArray = def.getAliases();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String alias = stringArray[n2];
                    if (alias.equals(command) && (argumentCount == def.getParams().length || argumentCount > def.getParams().length && def.isVarArgs())) {
                        return index;
                    }
                    ++n2;
                }
                ++index;
            }
            return -1;
        }
    }
}

