/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;

class CompositeCommandDictionary
implements Dictionary {
    LinkedHashSet<Dictionary> dicts = new LinkedHashSet();

    CompositeCommandDictionary() {
    }

    void add(Dictionary commandDictionary) {
        this.dicts.add(commandDictionary);
    }

    void remove(Dictionary commandDictionary) {
        this.dicts.remove(commandDictionary);
    }

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return this.containsCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public int findCommand(BasicCommand tc) {
        return this.findCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public boolean containsCommand(String command, int argumentCount) {
        for (Dictionary dict : this.dicts) {
            if (!dict.containsCommand(command, argumentCount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int findCommand(String command, int argumentCount) {
        int offset = 0;
        for (Dictionary dict : this.dicts) {
            if (dict.containsCommand(command, argumentCount)) {
                return offset + dict.findCommand(command, argumentCount);
            }
            offset += dict.size();
        }
        return -1;
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        ArrayList<DictionaryCommand> allCommands = new ArrayList<DictionaryCommand>();
        for (Dictionary dict : this.dicts) {
            for (DictionaryCommand def : dict) {
                allCommands.add(def);
            }
        }
        return allCommands.iterator();
    }

    @Override
    public int size() {
        int result = 0;
        for (Dictionary dict : this.dicts) {
            result += dict.size();
        }
        return result;
    }

    @Override
    public DictionaryCommand get(int index) {
        for (Dictionary dict : this.dicts) {
            if (index < dict.size()) {
                return dict.get(index);
            }
            index -= dict.size();
        }
        throw new IndexOutOfBoundsException("index=" + index);
    }
}

