/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class DemoCommands {
    @Command(description="Get the temperature of a module")
    public double getTemperature(@Argument(name="module", description="module (0-9)") int module) {
        if (module < 0 || module > 9) {
            throw new IllegalArgumentException("module < 0 or > 9");
        }
        return Math.random();
    }

    @Command(description="Add two arguments")
    public double add(double a, double b) {
        return a + b;
    }

    @Command(description="Add any number of arguments")
    public double addAll(double ... numbers) {
        double result = 0.0;
        double[] dArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            result += d;
            ++n2;
        }
        return result;
    }

    @Command(description="Convert day of week to an ordinal")
    public int dayOfWeek(@Argument(name="Day") Day day) {
        return day.ordinal();
    }

    @Command(description="Always generates an error")
    public void error() {
        throw new UnsupportedOperationException("This command not allowed");
    }

    public static enum Day {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

