/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryParameter;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class HelpGenerator {
    private final Dictionary dict;
    private final PrintWriter out;

    public HelpGenerator(PrintWriter out, Dictionary dict) {
        this.out = out;
        this.dict = dict;
    }

    @Command(description="List available commands")
    public void help() {
        ArrayList<DictionaryCommand> sorted = new ArrayList<DictionaryCommand>();
        for (DictionaryCommand def : this.dict) {
            sorted.add(def);
        }
        Collections.sort(sorted, new CommandDefinitionComparator());
        for (DictionaryCommand def : sorted) {
            this.helpForCommand(def);
        }
    }

    @Command(description="Show help for a single command")
    public void help(@Argument(name="command") String command) {
        boolean foundCommand = false;
        for (DictionaryCommand def : this.dict) {
            if (!def.getCommandName().equals(command)) continue;
            foundCommand = true;
            this.helpForCommand(def);
            DictionaryParameter[] dictionaryParameterArray = def.getParams();
            int n = dictionaryParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                DictionaryParameter param = dictionaryParameterArray[n2];
                this.out.printf("\t%s %s %s\n", param.getName(), param.getType(), param.getDescription());
                ++n2;
            }
        }
        if (!foundCommand) {
            throw new IllegalArgumentException("No help found for " + command);
        }
    }

    private void helpForCommand(DictionaryCommand def) {
        StringBuilder builder = new StringBuilder();
        builder.append(def.getCommandName());
        DictionaryParameter[] dictionaryParameterArray = def.getParams();
        int n = dictionaryParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DictionaryParameter param = dictionaryParameterArray[n2];
            builder.append(' ').append(param.getName());
            ++n2;
        }
        if (def.isVarArgs()) {
            builder.append("...");
        }
        this.out.printf("%-30s %s\n", builder, def.getDescription());
    }

    private static class CommandDefinitionComparator
    implements Comparator<DictionaryCommand> {
        private CommandDefinitionComparator() {
        }

        @Override
        public int compare(DictionaryCommand o1, DictionaryCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }
}

