/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.utilities.tracers.Tracer;

class DictionaryBuilder {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !DictionaryBuilder.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", DictionaryBuilder.class, (String)"org-lsst-ccs-command-core")) {
            throw new AssertionError();
        }
    }

    DictionaryBuilder() {
    }

    Dictionary build(Class targetClass) {
        CommandDictionaryImplementation dict = new CommandDictionaryImplementation();
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Command annotation = method.getAnnotation(Command.class);
            if (annotation != null) {
                dict.add(new DictionaryCommand(method, annotation));
            }
            ++n2;
        }
        return dict;
    }

    private static class CommandDictionaryImplementation
    extends ArrayList<DictionaryCommand>
    implements Dictionary {
        private CommandDictionaryImplementation() {
        }

        @Override
        public boolean containsCommand(TokenizedCommand tc) {
            return this.findCommand(tc) != -1;
        }

        @Override
        public int findCommand(TokenizedCommand tc) {
            int index = 0;
            for (DictionaryCommand def : this) {
                if (def.getCommandName().equals(tc.getCommand()) && (tc.getArgumentCount() == def.getParams().length || tc.getArgumentCount() > def.getParams().length && def.isVarArgs())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

