/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.tom.MessageID;
import org.jgroups.util.Util;

public class ToaHeader
extends Header {
    public static final byte DATA_MESSAGE = 1;
    public static final byte PROPOSE_MESSAGE = 2;
    public static final byte FINAL_MESSAGE = 4;
    public static final byte SINGLE_DESTINATION_MESSAGE = 8;
    private byte type = 0;
    private MessageID messageID;
    private long sequencerNumber;
    private Collection<Address> destinations = new ArrayList<Address>();

    public ToaHeader() {
        this.messageID = new MessageID();
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public Address getOrigin() {
        return this.messageID.getAddress();
    }

    public void addDestinations(Collection<Address> addresses) {
        if (addresses != null && !addresses.isEmpty()) {
            for (Address address : addresses) {
                if (this.destinations.contains(address)) continue;
                this.destinations.add(address);
            }
        }
    }

    public Collection<Address> getDestinations() {
        return this.destinations;
    }

    public long getSequencerNumber() {
        return this.sequencerNumber;
    }

    public void setSequencerNumber(long sequencerNumber) {
        this.sequencerNumber = sequencerNumber;
    }

    public byte getType() {
        return this.type;
    }

    @Override
    public int size() {
        return (int)((long)(1 + this.messageID.serializedSize() + Util.size(this.sequencerNumber)) + Util.size(this.destinations));
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        this.messageID.writeTo(out);
        Util.writeLong(this.sequencerNumber, out);
        Util.writeAddresses(this.destinations, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        this.messageID.readFrom(in);
        this.sequencerNumber = Util.readLong(in);
        this.destinations = Util.readAddresses(in, ArrayList.class);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ToaHeader [").append("type=").append(ToaHeader.type2String(this.type)).append(", message_id=").append(this.messageID).append(", sequence_number=").append(this.sequencerNumber).append(", destinations=").append(this.destinations).append("]");
        return sb.toString();
    }

    public static String type2String(byte type) {
        switch (type) {
            case 1: {
                return "DATA_MESSAGE";
            }
            case 2: {
                return "PROPOSE_MESSAGE";
            }
            case 4: {
                return "FINAL_MESSAGE";
            }
            case 8: {
                return "SINGLE_DESTINATION_MESSAGE";
            }
        }
        return "UNKNOWN";
    }

    public static ToaHeader createNewHeader(byte type, MessageID messageID) {
        if (messageID == null) {
            throw new NullPointerException("The message ID can't be null");
        }
        ToaHeader header = new ToaHeader();
        header.setType(type);
        header.setMessageID(messageID);
        return header;
    }

    public static ToaHeader createSingleDestinationHeader() {
        ToaHeader header = new ToaHeader();
        header.setType((byte)8);
        return header;
    }

    private void setType(byte type) {
        this.type = type;
    }

    private void setMessageID(MessageID messageID) {
        this.messageID = messageID;
    }
}

