/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.demo.ExtendedDemoCommands;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandClient;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;
import org.lsst.ccs.demo.shell.SwingShell;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.utilities.logging.Logger;

public class Main {
    public static void main(String[] args) throws Exception {
        Options mainOptions = new Options();
        mainOptions.addOption("h", "help", false, "Print the help message");
        mainOptions.addOption("m", "mode", true, "The MODE in which the shell operates.\n\tshell -- run the interactive shell locally\tserver -- run a distributed command server\tclient -- run a distributed command client\tgui -- an interactive gui, the default");
        mainOptions.getOption("mode").setArgName("MODE");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(mainOptions, args, true);
        boolean printHelp = false;
        if (line.hasOption("help")) {
            printHelp = true;
        } else {
            String mode = line.getOptionValue("mode");
            Main main = new Main();
            if (mode != null) {
                switch (mode) {
                    case "shell": {
                        Main.runShell();
                        break;
                    }
                    case "client": {
                        Main.runClient();
                        break;
                    }
                    case "server": {
                        Main.runServer();
                        break;
                    }
                    case "gui": {
                        main.runGui();
                        break;
                    }
                    default: {
                        printHelp = true;
                        break;
                    }
                }
            } else {
                main.runGui();
            }
        }
        if (printHelp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "Command Demo", "", mainOptions, "", true);
        }
    }

    private void runGui() throws IOException {
        GUIPanel gui = new GUIPanel();
        JFrame frame = new JFrame("CCS Command Demo");
        frame.setContentPane(gui);
        frame.setDefaultCloseOperation(3);
        frame.setLocationByPlatform(true);
        frame.pack();
        frame.setVisible(true);
    }

    private static void runShell() throws IOException, Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        JLineShell shell = new JLineShell(builder.buildCommandSet((Object)new ExtendedDemoCommands()));
        shell.run();
    }

    private static void runClient() throws Exception {
        try (JGroupsCommandClient client = new JGroupsCommandClient();){
            JLineShell shell = new JLineShell((CommandSet)client);
            shell.run();
        }
    }

    private static void runServer() throws Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        JGroupsCommandServer server = new JGroupsCommandServer(builder.buildCommandSet((Object)new ExtendedDemoCommands()));
    }

    private static class GUIPanel
    extends JPanel
    implements ActionListener {
        public GUIPanel() {
            this.addButton(new JButton("Open Local Shell"), "shell");
            this.addButton(new JButton("Open Distributed command client"), "client");
            this.addButton(new JButton("Run Distributed command server"), "server");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String command;
                switch (command = e.getActionCommand()) {
                    case "shell": {
                        this.runShell();
                        break;
                    }
                    case "client": {
                        this.runClient();
                        break;
                    }
                    case "server": {
                        this.runServer();
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger((String)Main.class.getName()).severe((Object)"Null", (Throwable)ex);
            }
        }

        private void runShell() throws IOException {
            CommandSetBuilder builder = new CommandSetBuilder();
            final SwingShell swingShell = new SwingShell(builder.buildCommandSet((Object)new ExtendedDemoCommands()), "Swing Shell");
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        swingShell.run();
                    }
                    catch (IOException ex) {
                        Logger.getLogger((String)Main.class.getName()).severe((Object)"Null", (Throwable)ex);
                    }
                }
            };
            t.start();
        }

        private void runClient() throws Exception {
            JGroupsCommandClient client = new JGroupsCommandClient();
            final SwingShell swingShell = new SwingShell(client, "Remote Swing Shell");
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        swingShell.run();
                    }
                    catch (IOException ex) {
                        Logger.getLogger((String)Main.class.getName()).severe((Object)"Null", (Throwable)ex);
                    }
                }
            };
            t.start();
        }

        private void runServer() {
        }

        private void addButton(JButton jButton, String command) {
            this.add(jButton);
            jButton.setActionCommand(command);
            jButton.addActionListener(this);
        }
    }
}

