/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.logging.Log;
import org.jgroups.protocols.FD;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

@Unsupported
public class FD_PING
extends FD {
    @Property(description="Command (script or executable) to ping a host: a return value of 0 means success, anything else is a failure. Default is ping")
    String cmd = "ping";
    @Property(description="Write the stdout of the command to the log. Default is true")
    boolean verbose = true;

    @Override
    protected FD.Monitor createMonitor() {
        return new PingMonitor();
    }

    protected static class Pinger {
        protected Pinger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int execute(String command, Log log) throws IOException, InterruptedException {
            Process p = Runtime.getRuntime().exec(command);
            InputStream in = p.getInputStream();
            InputStream err = p.getErrorStream();
            try {
                Reader in_reader = new Reader(in, log);
                Reader err_reader = new Reader(err, log);
                in_reader.start();
                err_reader.start();
                in_reader.join();
                err_reader.join();
                int n = p.exitValue();
                return n;
            }
            finally {
                Util.close(in);
                Util.close(err);
            }
        }

        static class Reader
        extends Thread {
            InputStreamReader in;
            Log log = null;
            boolean trace = false;

            Reader(InputStream in, Log log) {
                this.in = new InputStreamReader(in);
                this.log = log;
                if (log != null) {
                    this.trace = log.isTraceEnabled();
                }
            }

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                try {
                    int c;
                    while ((c = this.in.read()) != -1) {
                        sb.append((char)c);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(sb.toString());
                }
            }
        }
    }

    protected class PingMonitor
    extends FD.Monitor {
        protected PingMonitor() {
        }

        @Override
        public void run() {
            block11: {
                if (FD_PING.this.ping_dest == null) {
                    if (FD_PING.this.log.isWarnEnabled()) {
                        FD_PING.this.log.warn("ping_dest is null: members=" + FD_PING.this.members + ", pingable_mbrs=" + FD_PING.this.pingable_mbrs + ", local_addr=" + FD_PING.this.local_addr);
                    }
                    return;
                }
                String host = FD_PING.this.ping_dest instanceof IpAddress ? ((IpAddress)FD_PING.this.ping_dest).getIpAddress().getHostAddress() : FD_PING.this.ping_dest.toString();
                String command = FD_PING.this.cmd + " " + host;
                if (FD_PING.this.log.isDebugEnabled()) {
                    FD_PING.this.log.debug("executing \"" + command + "\" (own address=" + FD_PING.this.local_addr + ')');
                }
                try {
                    Log tmp_log = FD_PING.this.verbose ? FD_PING.this.log : null;
                    int rc = Pinger.execute(command, tmp_log);
                    ++FD_PING.this.num_heartbeats;
                    if (rc == 0) {
                        FD_PING.this.num_tries = 0;
                    } else {
                        ++FD_PING.this.num_tries;
                        if (FD_PING.this.log.isDebugEnabled()) {
                            FD_PING.this.log.debug("could not ping " + FD_PING.this.ping_dest + " (tries=" + FD_PING.this.num_tries + ')');
                        }
                    }
                    if (FD_PING.this.num_tries >= FD_PING.this.max_tries) {
                        if (FD_PING.this.log.isDebugEnabled()) {
                            FD_PING.this.log.debug("[" + FD_PING.this.local_addr + "]: could not ping " + FD_PING.this.ping_dest + " for " + (FD_PING.this.num_tries + 1) + " times (" + (long)(FD_PING.this.num_tries + 1) * FD_PING.this.timeout + " milliseconds), suspecting it");
                        }
                        FD_PING.this.bcast_task.addSuspectedMember(FD_PING.this.ping_dest);
                        FD_PING.this.num_tries = 0;
                        if (FD_PING.this.stats) {
                            ++FD_PING.this.num_suspect_events;
                            FD_PING.this.suspect_history.add(FD_PING.this.ping_dest);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!FD_PING.this.log.isErrorEnabled()) break block11;
                    FD_PING.this.log.error("failed executing command " + command, ex);
                }
            }
        }
    }
}

