package org.lsst.ccs.command.demo.subsystem;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;

/**
 *
 * @author tonyj
 */
public class Subsystem {

    private final String subsystemName;
    private final ModuleA a;
    private final ModuleB b;
    private final ModuleC c;
    private final ModuleA a1;

    public Subsystem(String name) {
        this.subsystemName = name;
        a = new ModuleA();
        b = new ModuleB();
        c = new ModuleC();
        a1 = new ModuleA("A1");
    }

    @Command(description = "Return the subsystem name")
    public String showName() {
        return subsystemName;
    }
    
    @Command(level=Command.ENGINEERING_ADVANCED)
    public String ENGINEERING_ADVANCEDCommand() {
        return subsystemName;
    }

    public static void main(String[] args) throws Exception {
        // Create Subsystem itself
        Subsystem s = new Subsystem("Test");
        CompositeCommandSet cs = s.createCommandSet();
        // Publish dictionary on "buses"
        JGroupsCommandServer server = new JGroupsCommandServer(cs);
    }

    public CompositeCommandSet createCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();

        RoutingCommandSet rcsA = new RoutingCommandSet("A", builder.buildCommandSet(a));
        RoutingCommandSet rcsA1 = new RoutingCommandSet("A/A1", builder.buildCommandSet(a));
        RoutingCommandSet rcsB = new RoutingCommandSet("B", builder.buildCommandSet(b));
        RoutingCommandSet rcsC = new RoutingCommandSet("B/C", builder.buildCommandSet(c));
        CompositeCommandSet cs = new CompositeCommandSet();
        cs.add(builder.buildCommandSet(this));
        cs.add(rcsB);
        cs.add(rcsA);
        cs.add(rcsC);
        cs.add(rcsA1);
        RouteSelectionCommandSet rs_cs = new RouteSelectionCommandSet(cs);
        return rs_cs;
    }
}
