/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.subsystem;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;
import org.lsst.ccs.command.demo.subsystem.ModuleA;
import org.lsst.ccs.command.demo.subsystem.ModuleB;
import org.lsst.ccs.command.demo.subsystem.ModuleC;

public class Subsystem {
    private final String subsystemName;
    private final ModuleA a;
    private final ModuleB b;
    private final ModuleC c;
    private final ModuleA a1;

    public Subsystem(String name) {
        this.subsystemName = name;
        this.a = new ModuleA();
        this.b = new ModuleB();
        this.c = new ModuleC();
        this.a1 = new ModuleA("A1");
    }

    @Command(description="Return the subsystem name")
    public String showName() {
        return this.subsystemName;
    }

    @Command(level=3)
    public String engineering3Command() {
        return this.subsystemName;
    }

    public static void main(String[] args) throws Exception {
        Subsystem s = new Subsystem("Test");
        CompositeCommandSet cs = s.createCommandSet();
        JGroupsCommandServer server = new JGroupsCommandServer(cs);
    }

    public CompositeCommandSet createCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();
        RoutingCommandSet rcsA = new RoutingCommandSet("A", builder.buildCommandSet(this.a));
        RoutingCommandSet rcsA1 = new RoutingCommandSet("A/A1", builder.buildCommandSet(this.a));
        RoutingCommandSet rcsB = new RoutingCommandSet("B", builder.buildCommandSet(this.b));
        RoutingCommandSet rcsC = new RoutingCommandSet("B/C", builder.buildCommandSet(this.c));
        CompositeCommandSet cs = new CompositeCommandSet();
        cs.add(builder.buildCommandSet(this));
        cs.add(rcsB);
        cs.add(rcsA);
        cs.add(rcsC);
        cs.add(rcsA1);
        RouteSelectionCommandSet rs_cs = new RouteSelectionCommandSet(cs);
        return rs_cs;
    }
}

