/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.remote.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Exchanger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.remote.CommandClient;
import org.lsst.ccs.command.remote.CommandResponse;
import org.lsst.ccs.utilities.logging.Logger;

public class JGroupsCommandClient
extends CompositeCommandSet
implements CommandClient,
Closeable {
    private static final Logger logger = Logger.getLogger((String)JGroupsCommandClient.class.getName());
    private final JChannel channel;
    private final Exchanger<CommandResponse> exchanger = new Exchanger();
    private View view;

    public JGroupsCommandClient() throws Exception {
        this.channel = new JChannel();
        this.channel.setReceiver((Receiver)new ClientReceiverAdapter());
        this.channel.connect("CCSRemoteCommandDemo");
        CommandSetBuilder builder = new CommandSetBuilder();
        this.add(builder.buildCommandSet(new BuiltIns()));
        this.channel.send(new Message(null, (Object)"Hello"));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public class BuiltIns {
        @Command(description="Show status of cluster")
        public void status() {
            for (Address address : JGroupsCommandClient.this.view) {
                System.out.println(address);
            }
        }
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final Address src;
        private final Dictionary dict;

        private CommandSetImplementation(Address src, Dictionary dict) {
            this.src = src;
            this.dict = dict;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict;
        }

        @Override
        public Object invoke(BasicCommand tc) throws CommandInvocationException {
            try {
                Message msg = new Message(this.src, (Object)tc);
                JGroupsCommandClient.this.channel.send(msg);
                return ((CommandResponse)JGroupsCommandClient.this.exchanger.exchange(null)).getResult();
            }
            catch (CommandInvocationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandInvocationException("Unable to send command", ex);
            }
        }

        private Object getAddress() {
            return this.src;
        }
    }

    private class ClientReceiverAdapter
    extends ReceiverAdapter {
        private ClientReceiverAdapter() {
        }

        public void viewAccepted(View view) {
            JGroupsCommandClient.this.view = view;
            ArrayList<CommandSetImplementation> maybeDelete = new ArrayList<CommandSetImplementation>();
            for (CommandSet commandSet : JGroupsCommandClient.this.getCommandSets()) {
                if (!(commandSet instanceof CommandSetImplementation)) continue;
                maybeDelete.add((CommandSetImplementation)commandSet);
            }
            for (Address address : view) {
                Iterator it = maybeDelete.iterator();
                while (it.hasNext()) {
                    CommandSetImplementation set = (CommandSetImplementation)it.next();
                    if (!set.getAddress().equals(address)) continue;
                    it.remove();
                }
            }
            for (CommandSet commandSet : maybeDelete) {
                JGroupsCommandClient.this.remove(commandSet);
            }
        }

        public void receive(Message msg) {
            Object obj = msg.getObject();
            if (obj instanceof Dictionary) {
                Address src = msg.getSrc();
                JGroupsCommandClient.this.add(new CommandSetImplementation(src, (Dictionary)obj));
            } else if (obj instanceof CommandResponse) {
                try {
                    JGroupsCommandClient.this.exchanger.exchange((CommandResponse)obj);
                }
                catch (InterruptedException ex) {
                    logger.severe((Object)"Interrupt while exchanging response", (Throwable)ex);
                }
            }
        }
    }
}

