package org.lsst.ccs.command.demo.subsystem;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;

/**
 *
 * @author tonyj
 */
public class Subsystem {

    private final String subsystemName;
    private final ModuleA a;
    private final ModuleB b;

    public Subsystem(String name) {
        this.subsystemName = name;
        a = new ModuleA();
        b = new ModuleB();
    }

    @Command(description = "Return the subsystem name")
    public String showName() {
        return subsystemName;
    }

    public static void main(String[] args) throws Exception {
        // Create Subsystem itself
        Subsystem s = new Subsystem("Test");
        CompositeCommandSet cs = s.createCommandSet();
        // Publish dictionary on "buses"
        JGroupsCommandServer server = new JGroupsCommandServer(cs);
    }

    public CompositeCommandSet createCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();

        RoutingCommandSet rcsA = new RoutingCommandSet("A", builder.buildCommandSet(a));
        RoutingCommandSet rcsB = new RoutingCommandSet("B", builder.buildCommandSet(b));
        CompositeCommandSet cs = new CompositeCommandSet();
        cs.add(builder.buildCommandSet(this));
        cs.add(rcsB);
        cs.add(rcsA);
        RouteSelectionCommandSet rs_cs = new RouteSelectionCommandSet(cs);
        return rs_cs;
    }
}
