/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.demo.shell;

import com.wittams.gritty.Questioner;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.Tty;
import com.wittams.gritty.swing.GrittyTerminal;
import com.wittams.gritty.swing.TermPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JFrame;
import jline.Terminal;
import jline.console.ConsoleReader;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.shell.JLineShell;

public class SwingShell {
    private final GrittyTerminal terminal;
    private final JLineShell shell;
    private final JFrame frame;

    public SwingShell(CommandSet userCommands, String title) throws IOException {
        this.frame = new JFrame(title);
        this.terminal = new GrittyTerminal();
        TermPanel termPanel = this.terminal.getTermPanel();
        this.frame.setContentPane((Container)this.terminal);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLocationByPlatform(true);
        termPanel.setVisible(true);
        this.frame.setVisible(true);
        this.frame.setResizable(true);
        termPanel.setResizePanelDelegate((pixelDimension, origin) -> {
            if (origin == RequestOrigin.Remote) {
                this.sizeFrameForTerm(this.frame);
            }
        });
        TtyImpl tty = new TtyImpl();
        this.terminal.setTty((Tty)tty);
        ConsoleReader reader = new ConsoleReader((InputStream)tty.getInputStream(), (OutputStream)tty.getOutputStream(), (Terminal)new SwingTerminal());
        this.shell = new JLineShell(userCommands, reader);
    }

    public void run() throws IOException {
        this.terminal.start();
        try {
            this.shell.run();
        }
        finally {
            this.terminal.stop();
            this.frame.setVisible(false);
        }
    }

    public static void main(String[] args) throws IOException {
        CommandSetBuilder builder = new CommandSetBuilder();
        SwingShell swingShell = new SwingShell(builder.buildCommandSet((Object)new DemoCommands()), "Swing Shell");
        swingShell.run();
    }

    private void sizeFrameForTerm(JFrame frame) {
        Dimension d = this.terminal.getPreferredSize();
        d.width += frame.getWidth() - frame.getContentPane().getWidth();
        d.height += frame.getHeight() - frame.getContentPane().getHeight();
        frame.setSize(d);
    }

    private static class SwingTerminal
    implements Terminal {
        private SwingTerminal() {
        }

        public void init() throws Exception {
        }

        public void restore() throws Exception {
        }

        public void reset() throws Exception {
        }

        public boolean isSupported() {
            return true;
        }

        public int getWidth() {
            return 80;
        }

        public int getHeight() {
            return 100;
        }

        public boolean isAnsiSupported() {
            return false;
        }

        public OutputStream wrapOutIfNeeded(OutputStream out) {
            return out;
        }

        public InputStream wrapInIfNeeded(InputStream in) throws IOException {
            return in;
        }

        public boolean hasWeirdWrap() {
            return false;
        }

        public boolean isEchoEnabled() {
            return false;
        }

        public void setEchoEnabled(boolean bln) {
        }
    }

    private class TtyImpl
    implements Tty {
        private final BlockingQueue<byte[]> inputQueue = new LinkedBlockingQueue<byte[]>();
        private final BlockingQueue<byte[]> outputQueue = new LinkedBlockingQueue<byte[]>();
        private final TtyInputStream inputStream = new TtyInputStream();
        private final TtyOutputStream outputStream = new TtyOutputStream();

        public boolean init(Questioner qstnr) {
            return true;
        }

        public void close() {
        }

        public void resize(Dimension dmnsn, Dimension dmnsn1) {
        }

        public String getName() {
            return "Test";
        }

        public int read(byte[] bytes, int i, int i1) throws IOException {
            try {
                byte[] src = this.outputQueue.take();
                System.arraycopy(src, 0, bytes, i, src.length);
                return src.length;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }

        public void write(byte[] bytes) throws IOException {
            try {
                this.inputQueue.put(bytes);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }

        public TtyInputStream getInputStream() {
            return this.inputStream;
        }

        public TtyOutputStream getOutputStream() {
            return this.outputStream;
        }

        private class TtyInputStream
        extends InputStream {
            private byte[] currentBuffer;
            private int pos;

            private TtyInputStream() {
            }

            @Override
            public int read() throws IOException {
                try {
                    while (this.currentBuffer == null || this.currentBuffer.length <= this.pos) {
                        this.currentBuffer = (byte[])TtyImpl.this.inputQueue.take();
                        this.pos = 0;
                    }
                    return this.currentBuffer[this.pos++];
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    if (this.currentBuffer == null || this.currentBuffer.length <= this.pos) {
                        this.currentBuffer = (byte[])TtyImpl.this.inputQueue.take();
                        this.pos = 0;
                    }
                    int actual = Math.min(len, this.currentBuffer.length - this.pos);
                    System.arraycopy(this.currentBuffer, this.pos, b, off, actual);
                    this.pos += actual;
                    return actual;
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
        }

        private class TtyOutputStream
        extends OutputStream {
            private TtyOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    byte[] buffer = new byte[]{(byte)b};
                    TtyImpl.this.outputQueue.put(buffer);
                    if (b == 10) {
                        byte[] buffer2 = new byte[]{13};
                        TtyImpl.this.outputQueue.put(buffer2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
        }
    }
}

