package org.lsst.ccs.command.demo.subsystem;

import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;

/**
 *
 * @author tonyj
 */
public class Subsystem {

    private String subsystemName;
    private Subsystem(String name) {
        this.subsystemName = name;
    }

    @Command(description = "Return the subsystem name")
    public String showName() {
        return subsystemName;
    }
    
    public static void main(String[] args) throws Exception {
        // Create Subsystem itself
        Subsystem s = new Subsystem("Test");
        ModuleA a = new ModuleA();
        ModuleB b = new ModuleB();
        
        CommandSetBuilder builder = new CommandSetBuilder();

        RoutingCommandSet rcs = new RoutingCommandSet();
        rcs.add("A",builder.buildCommandSet(a));
        rcs.add("B",builder.buildCommandSet(b));
        
        // Build dictionary
        CompositeCommandSet cs = new CompositeCommandSet();
        
        cs.add(builder.buildCommandSet(s));
        cs.add(rcs);
        // Publish dictionary on "buses"
        JGroupsCommandServer server = new JGroupsCommandServer(cs);
    }
}
