/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandClient;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;
import org.lsst.ccs.demo.shell.SwingShell;
import org.lsst.ccs.shell.JLineShell;

public class Main {
    public static void main(String[] args) throws Exception {
        boolean printHelp;
        Options mainOptions;
        block18: {
            Main main;
            block19: {
                CommandLine line;
                block17: {
                    mainOptions = new Options();
                    mainOptions.addOption("h", "help", false, "Print the help message");
                    mainOptions.addOption("m", "mode", true, "The MODE in which the shell operates.\n\tshell -- run the interactive shell locally\tserver -- run a command server\tclient -- run a command client server\tgui -- an interactive gui, the default");
                    mainOptions.getOption("mode").setArgName("MODE");
                    BasicParser parser = new BasicParser();
                    line = parser.parse(mainOptions, args, true);
                    printHelp = false;
                    if (!line.hasOption("help")) break block17;
                    printHelp = true;
                    break block18;
                }
                String mode = line.getOptionValue("mode");
                main = new Main();
                if (mode == null) break block19;
                switch (mode) {
                    case "shell": {
                        main.runShell();
                        break;
                    }
                    case "client": {
                        main.runClient();
                        break;
                    }
                    case "server": {
                        main.runServer();
                        break;
                    }
                    case "gui": {
                        main.runGui();
                        break;
                    }
                    default: {
                        printHelp = true;
                        break;
                    }
                }
                break block18;
            }
            main.runGui();
        }
        if (printHelp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "Command Demo", "", mainOptions, "", true);
        }
    }

    private void runGui() throws IOException {
        GUIPanel gui = new GUIPanel();
        JFrame frame = new JFrame("CCS Command Demo");
        frame.setContentPane(gui);
        frame.setDefaultCloseOperation(3);
        frame.setLocationByPlatform(true);
        frame.pack();
        frame.setVisible(true);
    }

    private void runShell() throws IOException, Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        JLineShell shell = new JLineShell(builder.buildCommandSet((Object)new DemoCommands()));
        shell.run();
    }

    private void runClient() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JGroupsCommandClient client = new JGroupsCommandClient();){
            JLineShell shell = new JLineShell((CommandSet)client);
            shell.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void runServer() throws Exception {
        CommandSetBuilder builder = new CommandSetBuilder();
        new JGroupsCommandServer(builder.buildCommandSet((Object)new DemoCommands()));
    }

    private static class GUIPanel
    extends JPanel
    implements ActionListener {
        public GUIPanel() {
            this.addButton(new JButton("Open Local Shell"), "shell");
            this.addButton(new JButton("Open Distributed Client Shell"), "command");
            this.addButton(new JButton("Open Distributed Command Shell"), "server");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String command;
                switch (command = e.getActionCommand()) {
                    case "shell": {
                        this.runShell();
                        break;
                    }
                    case "client": {
                        this.runClient();
                        break;
                    }
                    case "server": {
                        this.runServer();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void runShell() throws IOException {
            CommandSetBuilder builder = new CommandSetBuilder();
            final SwingShell swingShell = new SwingShell(builder.buildCommandSet((Object)new DemoCommands()), "Swing Shell");
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        swingShell.run();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            t.start();
        }

        private void runClient() {
        }

        private void runServer() {
        }

        private void addButton(JButton jButton, String command) {
            this.add(jButton);
            jButton.setActionCommand(command);
            jButton.addActionListener(this);
        }
    }
}

