/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.remote.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.remote.CommandResponse;
import org.lsst.ccs.command.remote.CommandServer;

public class JGroupsCommandServer
extends CommandServer
implements Closeable {
    private static final Logger logger = Logger.getLogger(JGroupsCommandServer.class.getName());
    static final String CCS_REMOTE_COMMAND_DEMO = "CCSRemoteCommandDemo";
    static final String HELLO = "Hello";
    private final JChannel channel;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public JGroupsCommandServer(CommandSet set) throws Exception {
        super(set);
        this.channel = new JChannel();
        this.channel.setReceiver((Receiver)new ReceiverAdapterImpl());
        this.channel.connect(CCS_REMOTE_COMMAND_DEMO);
        Message msg = new Message(null, (Object)set.getCommandDictionary());
        this.channel.send(msg);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            logger.log(Level.INFO, "Interrupted while closing server", ex);
        }
        this.channel.close();
    }

    private void send(Message msg) {
        try {
            this.channel.send(msg);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while sending message", ex);
        }
    }

    private class ReceiverAdapterImpl
    extends ReceiverAdapter {
        private ReceiverAdapterImpl() {
        }

        public void receive(Message msg) {
            final Object obj = msg.getObject();
            if (JGroupsCommandServer.HELLO.equals(obj)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Message msg = new Message(null, (Object)JGroupsCommandServer.this.getCommandSet().getCommandDictionary());
                        JGroupsCommandServer.this.send(msg);
                    }
                };
                JGroupsCommandServer.this.executor.submit(runnable);
            } else if (obj instanceof TokenizedCommand) {
                final Address src = msg.getSrc();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object result = JGroupsCommandServer.this.getCommandSet().invoke((TokenizedCommand)obj);
                            CommandResponse response = new CommandResponse((Serializable)result);
                            JGroupsCommandServer.this.send(new Message(src, (Object)response));
                        }
                        catch (CommandInvocationException ex) {
                            JGroupsCommandServer.this.send(new Message(src, (Object)new CommandResponse(ex)));
                        }
                    }
                };
                JGroupsCommandServer.this.executor.submit(runnable);
            }
        }
    }
}

