/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import org.lsst.ccs.bus.data.Alert;

public enum MpmAlert {
    POWER_PLC_NOT_ALIVE("PowerPLCNotAlive", "Power protection PLC not alive"),
    COLD_PLC_NOT_ALIVE("ColdPLCNotAlive", "Cold protection PLC not alive"),
    CRYO_PLC_NOT_ALIVE("CryoPLCNotAlive", "Cryo protection PLC not alive"),
    COLD_TEMP_HIGH("ColdTempHigh", "Cold temperature high"),
    COLD_TEMP_LOW("ColdTempLow", "Cold temperature low"),
    CRYO_TEMP_HIGH("CryoTempHigh", "Cryo temperature high"),
    CRYO_TEMP_LOW("CryoTempLow", "Cryo temperature low"),
    CRYO_VACUUM_BAD("CryoVacuumBad", "Cryo vacuum bad"),
    HEX_VACUUM_BAD("HexVacuumBad", "Hex vacuum bad"),
    UT_TEMP_HIGH("UtTempHigh", "UT temperature high"),
    UT_COOLANT_LEAK("UtCoolantLeak", "UT coolant leak"),
    UT_LEAK_DETC_FAULT("UtLeakDetcFault", "UT leak detector fault"),
    UT_SMOKE_DETC("UtSmokeDetc", "UT smoke detected"),
    UT_SMOKE_DETC_FAULT("UtSmokeDetcFault", "UT smoke detector fault");

    private final String id;
    private final String description;

    private MpmAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return new Alert(this.id, this.description);
    }
}

