/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.awt.Color;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsColors;

public class FcsEnumerations {

    public static enum IOModuleStatus implements FcsColors.ColoredObject
    {
        UNKNOWN_STATUS(0, Color.RED),
        IS_SOCKET_AT_STANDBY(1, FcsColors.green),
        IS_READY_NOT_IN_POSITION(2, Color.BLUE),
        ERROR_READING_POSITION(3, Color.RED),
        SAFE_STATE(4, Color.RED),
        BOOTING(5, FcsColors.orange1),
        NOT_POWERED_ON(6, Color.RED),
        NOT_WORKING_FOR_OTHER_REASON(7, FcsColors.chocolate);

        @SkipEncoding
        private final int status;
        @SkipEncoding
        private final Color color;

        private IOModuleStatus(int status, Color color) {
            this.status = status;
            this.color = color;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public static IOModuleStatus getStatusByCode(int s) {
            IOModuleStatus[] codes = IOModuleStatus.values();
            IOModuleStatus status = null;
            for (IOModuleStatus ioStatus : codes) {
                if (ioStatus.getStatus() != s) continue;
                status = ioStatus;
            }
            if (status == null) {
                throw new IllegalArgumentException(s + ": this status doesn't exist in IOModuleStatus ENUM");
            }
            return status;
        }
    }

    public static enum FilterClampState implements FcsColors.ColoredObject
    {
        READY_TO_LOCK(Color.BLUE, "READY TO LOCK"),
        UNLOCKED_ON_FILTER(FcsColors.chocolate, "UNLOCKED ON FILTER"),
        UNLOCKED_EMPTY(FcsColors.royalblue, "UNLOCKED AND EMPTY"),
        LOCKED_ON_FILTER(FcsColors.green, "LOCKED ON FILTER"),
        UNDEFINED(Color.ORANGE, "UNDEFINED"),
        ERROR(Color.RED, "IN ERROR"),
        UNLOCKABLE(FcsColors.magenta2, "FILTER UNLOCKABLE");

        @SkipEncoding
        private final String shortDescription;
        @SkipEncoding
        private final Color color;

        private FilterClampState(Color color, String aString) {
            this.shortDescription = aString;
            this.color = color;
        }

        public String toString() {
            return this.shortDescription;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    public static enum LockStatus implements FcsColors.ColoredObject
    {
        UNLOCKED(Color.BLUE, "UNLOCKED"),
        LOCKED(FcsColors.green, "LOCKED"),
        UNKNOWN(Color.ORANGE, "UNKNOWN"),
        ERROR(Color.RED, "IN ERROR"),
        RELAXED(FcsColors.lightblue, "RELAXED"),
        OPENED(Color.BLUE, "OPENED"),
        CLOSED(FcsColors.green, "CLOSED"),
        CLAMPED(FcsColors.darkGreen, "CLAMPED"),
        UNCLAMPED(Color.BLUE, "UNCLAMPED"),
        UNDER_CLAMPED(Color.YELLOW, "UNDER LOAD"),
        OVER_CLAMPED(Color.RED, " OVER LOAD"),
        INTRAVEL(Color.YELLOW, "IN TRAVEL"),
        NOERROR(Color.GREEN, "NO ERROR");

        @SkipEncoding
        private final Color color;
        @SkipEncoding
        private final String text;

        private LockStatus(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum FilterPresenceStatus implements FcsColors.ColoredObject
    {
        NOFILTER(Color.DARK_GRAY),
        ENGAGED(FcsColors.chocolate),
        LOCKABLE(FcsColors.green),
        NOT_LOCKABLE(Color.BLUE),
        ERROR(Color.RED),
        UNKNOWN(Color.YELLOW);

        @SkipEncoding
        private final Color color;

        private FilterPresenceStatus(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    public static enum FilterFamily {
        S("Science Filter"),
        D("Dummy Filter"),
        F("French Dummy Filter"),
        T("Test Filter LNL"),
        O("Open / Non Attributed Filter"),
        U("Unknown Filter"),
        N("No Filter");

        @SkipEncoding
        private final String familyName;

        private FilterFamily(String familyName) {
            this.familyName = familyName;
        }

        public String getFamilyName() {
            return this.familyName;
        }
    }

    public static enum LoaderCarrierLocation {
        STORAGE,
        HANDOFF,
        UNKNOWN,
        ERROR;

    }

    public static enum CarouselHoldingBrakesState {
        TRUE,
        FALSE;

    }

    public static enum BrakeState {
        CLOSED,
        NO_BRAKE,
        NO_SENSOR;

    }

    public static enum CarouselPowerMode {
        GO_TO_SLEEP,
        WAKE_UP,
        STAY_UP;

    }
}

