/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.CompletableUtils;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.SourceHandler;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

class ImageHandler
implements Callable<FileList> {
    private static final Logger LOG = Logger.getLogger(ImageHandler.class.getName());
    private final Image image;
    private final ImageHandlingConfig config;
    private final ExecutorService daqExecutor;
    private final List<RebNode> rebs;
    private final boolean isStreaming;
    private final CountDownLatch darkTime = new CountDownLatch(1);
    private final Map<String, Serializable> imageMetaData;
    private final PostImageFileHandling postImageFileHandling;

    ImageHandler(Map<String, Serializable> imageMetaData, Image image, ExecutorService daqExecutor, ImageHandlingConfig config, List<RebNode> rebs, boolean isStreaming, PostImageFileHandling postImageFileHandling) {
        this.imageMetaData = imageMetaData;
        this.image = image;
        this.config = config;
        this.daqExecutor = daqExecutor;
        this.rebs = rebs;
        this.isStreaming = isStreaming;
        this.postImageFileHandling = postImageFileHandling;
    }

    @Override
    public FileList call() throws IOException, DAQException, InterruptedException, ExecutionException {
        FileList result = new FileList();
        try {
            ImageName imageName = new ImageName(this.image.getMetaData().getName());
            List sources = this.image.listSources();
            LocationSet locationsToProcess = this.config.getLocationsToProcess();
            ArrayList lffl = new ArrayList();
            sources.stream().filter(arg_0 -> ImageHandler.lambda$call$0((Set)locationsToProcess, arg_0)).forEach(source -> {
                Location location = source.getLocation();
                for (RebNode r : this.rebs) {
                    if (!r.getLocation().equals((Object)location)) continue;
                    SourceHandler sourceHandler = new SourceHandler(this.imageMetaData, this.darkTime, imageName.toString(), (Source)source, this.config, r, this.isStreaming);
                    CompletableFuture<FileList> futureFilelist = CompletableUtils.asyncCallable(this.daqExecutor, sourceHandler);
                    CompletableFuture<FileList> asyncFutureFilelist = futureFilelist.thenApplyAsync(fl -> fl);
                    asyncFutureFilelist = this.postImageFileHandling.handleAsynchronousData(asyncFutureFilelist, imageName);
                    lffl.add(asyncFutureFilelist);
                    this.postImageFileHandling.handleFitsFileCommands(asyncFutureFilelist, location, imageName, "SCIENCE");
                }
            });
            for (Future ffl : lffl) {
                FileList fl = (FileList)ffl.get();
                result.addAll(fl);
            }
        }
        catch (IllegalArgumentException x) {
            LOG.log(Level.WARNING, "Invalid obsid for science image, ignored: " + this.image.getMetaData().getName(), x);
        }
        return result;
    }

    void darkTimeArrived() {
        this.darkTime.countDown();
    }

    String getImageName() {
        return this.image.getMetaData().getName();
    }

    private static /* synthetic */ boolean lambda$call$0(Set locationsToProcess, Source source) {
        return locationsToProcess.contains(source.getLocation());
    }
}

