/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.BulkPsPowerAction;
import org.lsst.ccs.subsystem.power.QuadBox;
import org.lsst.ccs.subsystem.power.RebPowerAlarm;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class BulkPSEmergencyResponseManager
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(BulkPSEmergencyResponseManager.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private QuadBox quadbox;
    private OriginManager originManager;
    private AlertPayloadListener alertPayloadListener = new AlertPayloadListener();
    private QuadboxEmergencyResponseDelegate quadboxEmergencyResponseDelegate;

    public void build() {
        if (this.quadbox == null) {
            throw new RuntimeException("Could not find an instance of QuadBox in the tree.");
        }
    }

    public void init() {
        this.alertService.startStatusAlertListening(info -> info.isAgentWorkerOrService());
        this.originManager = new OriginManager(this.agent.getName());
        this.quadboxEmergencyResponseDelegate = new QuadboxEmergencyResponseDelegate(this.quadbox);
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.originManager);
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        for (String switchName : this.quadbox.getSwitchNames()) {
            this.alertService.registerAlert(RebPowerAlarm.getRebPowerAlert(RebPowerAlertType.EMERGENCY_ACTION_FAILED, switchName), alwaysClear);
        }
    }

    public void start() {
        this.alertService.addListener((AlertListener)this.alertPayloadListener);
    }

    public void shutdown() {
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.originManager);
        this.alertService.removeListener((AlertListener)this.alertPayloadListener);
    }

    private class AlertPayloadListener
    implements AlertListener {
        private final List<String> initialized = new CopyOnWriteArrayList<String>();

        private AlertPayloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAlert(AlertEvent event) {
            if (BulkPSEmergencyResponseManager.this.originManager.getOrigins().contains(event.getSource())) {
                Alert alert = event.getAlert();
                AlertEvent.AlertEventType type = event.getType();
                String origin = event.getSource();
                if (null != type) {
                    List<String> list = this.initialized;
                    synchronized (list) {
                        if (type != AlertEvent.AlertEventType.AGENT_DISCONNECTION && !this.initialized.contains(origin)) {
                            this.initialized.add(origin);
                            this.processAlertSummary(event.getSummary(), origin);
                        } else {
                            switch (type) {
                                case ALERT_RAISED: {
                                    this.processAlert(origin, alert, event.getLevel());
                                }
                            }
                        }
                    }
                }
            }
        }

        private void processAlert(String origin, Alert alert, AlertState state) {
            BulkPsPowerAction rebPowerAction = BulkPsPowerAction.getBulkPsPowerActionPayloadFromAlert((Alert)alert);
            if (rebPowerAction != null) {
                BulkPSEmergencyResponseManager.this.quadboxEmergencyResponseDelegate.processEmergencyResponse(origin, alert, rebPowerAction);
            }
        }

        void processAlertSummary(RaisedAlertSummary summary, String origin) {
            for (RaisedAlertHistory alertHistory : summary.getAllRaisedAlertHistories()) {
                this.processAlert(origin, alertHistory.getLatestAlert(), alertHistory.getLatestAlertState());
            }
        }
    }

    private class OriginManager
    implements AgentPresenceListener {
        private final List<String> origins = new CopyOnWriteArrayList<String>();

        OriginManager(String agentName) {
            this.origins.add(agentName);
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                if (!ai.hasAgentProperty(BulkPsPowerAction.class.getCanonicalName())) continue;
                LOG.log(Level.INFO, "Adding agent {0} to list of origins for payload {1}", new Object[]{ai.getName(), BulkPsPowerAction.class.getCanonicalName()});
                this.origins.add(ai.getName());
                RaisedAlertSummary s = (RaisedAlertSummary)BulkPSEmergencyResponseManager.this.alertService.getAllSummaries().get(ai.getName());
                if (s == null) continue;
                BulkPSEmergencyResponseManager.this.alertPayloadListener.processAlertSummary(s, ai.getName());
            }
        }

        List<String> getOrigins() {
            return this.origins;
        }
    }

    private class QuadboxEmergencyResponseDelegate {
        private final QuadBox quadbox;

        public QuadboxEmergencyResponseDelegate(QuadBox quadbox) {
            this.quadbox = quadbox;
        }

        synchronized void processEmergencyResponse(String origin, Alert alert, BulkPsPowerAction bulkPsSwitchAction) {
            if (bulkPsSwitchAction != null) {
                String switchName = bulkPsSwitchAction.getBulkPsSwitchName();
                if (!this.quadbox.getSwitchNames().contains(switchName)) {
                    LOG.log(Level.SEVERE, "Switch name {0} does not exist. The emergency action {1} could not be performed.", new Object[]{switchName, bulkPsSwitchAction.getType()});
                } else {
                    BulkPSEmergencyResponseManager.this.agent.getScheduler().execute(() -> {
                        switch (bulkPsSwitchAction.getType()) {
                            case TURN_BULK_PS_OFF: {
                                LOG.log(Level.WARNING, "Turning OFF switch {0}", switchName);
                                try {
                                    this.quadbox.setSwitchOn(switchName, false);
                                }
                                catch (PowerException pe) {
                                    LOG.log(Level.SEVERE, "Could not turn OFF switch " + switchName, pe);
                                    BulkPSEmergencyResponseManager.this.alertService.raiseAlert(RebPowerAlarm.getRebPowerAlert(RebPowerAlertType.EMERGENCY_ACTION_FAILED, switchName), AlertState.ALARM, "Could not turn OFF switch " + switchName);
                                }
                                break;
                            }
                            default: {
                                LOG.log(Level.SEVERE, "Unknown Bulk PS Action {0} for switch {1}", new Object[]{bulkPsSwitchAction.getType(), switchName});
                            }
                        }
                    });
                }
            }
        }
    }
}

