/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.services.app;

import java.awt.datatransfer.Transferable;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.Application;
import org.freehep.application.services.FileAccess;
import org.freehep.application.services.ServiceManager;
import org.freehep.application.services.app.AppFileAccess;

public class AppServiceManager
implements ServiceManager {
    private PrinterJob pj;
    protected Application app = Application.getApplication();

    @Override
    public PageFormat getDefaultPage() {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        return this.pj.defaultPage();
    }

    @Override
    public PageFormat showPageFormatDialog(PageFormat page) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        return this.pj.pageDialog(page);
    }

    @Override
    public boolean print(Printable painter) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        this.pj.setPrintable(painter);
        return this.print();
    }

    @Override
    public boolean print(Pageable document) {
        if (this.pj == null) {
            this.pj = this.createPrintJob();
        }
        this.pj.setPageable(document);
        return this.print();
    }

    private boolean print() {
        if (!this.pj.printDialog()) {
            return false;
        }
        try {
            this.pj.print();
            boolean bl = true;
            return bl;
        }
        catch (PrinterException p) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.pj = null;
        }
    }

    private PrinterJob createPrintJob() {
        return PrinterJob.getPrinterJob();
    }

    private String userPrefFile() {
        return this.app.getAppProperties().getProperty("userPrefDir");
    }

    @Override
    public void loadUserPreferences(Properties props) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.userPrefFile()));){
            props.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeUserPreferences(Properties props) {
        try {
            File parent;
            File f = new File(this.userPrefFile());
            if (!f.exists() && !(parent = f.getParentFile()).exists()) {
                parent.mkdirs();
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.userPrefFile()));){
                props.store(out, this.app.getAppName() + " User Properties");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public FileAccess openFileDialog(FileFilter[] filters, FileFilter defaultFilter, String key) {
        String dir;
        JFileChooser dlg = new JFileChooser();
        Properties user = this.app.getUserProperties();
        if (key != null && (dir = user.getProperty(key)) != null) {
            dlg.setCurrentDirectory(new File(dir));
        }
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                dlg.addChoosableFileFilter(filters[i]);
            }
        }
        if (defaultFilter != null) {
            dlg.setFileFilter(defaultFilter);
        }
        if (dlg.showOpenDialog(this.app) == 0) {
            File file = dlg.getSelectedFile();
            if (key != null) {
                user.setProperty(key, file.getAbsolutePath());
            }
            return new AppFileAccess(file);
        }
        return null;
    }

    @Override
    public FileAccess saveFileAsDialog(FileFilter[] filters, FileFilter defaultFilter, String key, InputStream in) {
        String dir;
        JFileChooser dlg = new JFileChooser();
        Properties user = this.app.getUserProperties();
        if (key != null && (dir = user.getProperty(key)) != null) {
            dlg.setCurrentDirectory(new File(dir));
        }
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                dlg.addChoosableFileFilter(filters[i]);
            }
        }
        if (defaultFilter != null) {
            dlg.setFileFilter(defaultFilter);
        }
        if (dlg.showSaveDialog(this.app) == 0) {
            File file = dlg.getSelectedFile();
            if (key != null) {
                user.setProperty(key, file.getAbsolutePath());
            }
            return new AppFileAccess(file);
        }
        return null;
    }

    @Override
    public boolean isAvailable(String part) {
        return true;
    }

    @Override
    public boolean makeAvailable(String part) {
        return true;
    }

    @Override
    public Transferable getClipboardContents() {
        return this.app.getToolkit().getSystemClipboard().getContents(null);
    }

    @Override
    public void setClipboardContents(Transferable contents) {
        this.app.getToolkit().getSystemClipboard().setContents(contents, null);
    }
}

